/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.freehandalgorrithmic;

import de.jave.jave.Jave;
import de.jave.jave.LineAlgorithm;
import de.jave.jave.Tool;
import de.jave.jave.algorithm.freehandalgorithmic.FreehandAlgorithm;
import de.jave.jave.algorithm.freehandalgorithmic.FreehandAlgorithmicMode;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rendering.PixelPlateRenderer;
import de.jave.jave.tool.freehandalgorrithmic.FreehandAlgorithmicOptions;
import de.jave.jave.tool.freehandalgorrithmic.FreehandAlgorithmicOptionsPanel;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public final class FreehandAlgorithmicTool
extends Tool {
    private Point location1;
    private final FreehandAlgorithmicOptions options = new FreehandAlgorithmicOptions();
    private boolean upToDate = false;

    public FreehandAlgorithmicTool(JaveMainPanel plate, Jave asciiPainter) {
        super(plate, asciiPainter);
    }

    public final String getName() {
        return "Freehand Algorithmic";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/freehand.gif");
    }

    public final JComponent createOptionsComponent() {
        return new FreehandAlgorithmicOptionsPanel(this.options, this.getMouseCharacterModel(), this.getMixCharactersModel()).getContent();
    }

    public final void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    public final void putAside(boolean nextToolIsSelectionTool) {
    }

    public final void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        this.upToDate = false;
        this.markPlate = new PixelPlate(location.x - 10, location.y - 10, 20, 20);
        this.markPlate.setMode(PixelPlateMode.CHAR);
        this.markPlate.set(location.x, location.y);
        FreehandAlgorithmicMode mode = this.options.getMode();
        if (mode == FreehandAlgorithmicMode.CHARACTERS) {
            this.markPlate.setCharacter(this.getMouseCharacterModel().getCharacter(evt.isMetaDown()));
        } else {
            this.markPlate.setCharacter('#');
        }
        this.location1 = location;
        this.repaintCursor();
    }

    public final void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.markPlate == null) {
            return;
        }
        this.setMixMode(this.isMix());
        if (!this.upToDate) {
            this.convert();
        }
        this.markPlate.pasteResultInto(this.getPlate().getContent());
        this.markPlate = null;
        this.saveCurrentState("freehand");
        this.repaintAll();
    }

    public final void keyPressed(int code, KeyEvent evt) {
        if (code == 27) {
            this.markPlate = null;
            this.location1 = null;
            this.repaintCursor();
            return;
        }
    }

    public final void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.markPlate == null || location == null || this.location1 == null) {
            return;
        }
        if (location.equals(this.location1)) {
            return;
        }
        this.upToDate = false;
        LineAlgorithm.drawLineBresenham(this.markPlate, location, this.location1, this.markPlate.getCharacter());
        this.location1 = location;
        this.repaintCursor();
        this.showCoordinates(location);
    }

    public final void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.markPlate == null) {
            return;
        }
        this.convert();
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
    }

    private void convert() {
        FreehandAlgorithmicMode mode = this.options.getMode();
        FreehandAlgorithm.convertMarksToFreehandLine(this.markPlate, mode);
        this.upToDate = true;
    }
}

