/*
 * Decompiled with CFR 0.152.
 */
package de.jave.preferences;

import java.io.File;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import net.disy.commons.core.util.Ensure;

public class SmartPreferences {
    private final Preferences preferences;

    public SmartPreferences(Preferences preferences) {
        Ensure.ensureArgumentNotNull(preferences);
        this.preferences = preferences;
    }

    public final Preferences getSubPreferences(String path) {
        return this.preferences.node(path);
    }

    public final void put(String key, String value) {
        if (value == null) {
            this.preferences.remove(key);
            return;
        }
        this.preferences.put(key, value);
    }

    protected final void put(String key, File file) {
        this.put(key, file == null ? (String)null : file.getAbsolutePath());
    }

    protected final File getFile(String key) {
        String fileName = this.get(key, null);
        if (fileName == null) {
            return null;
        }
        return new File(fileName);
    }

    public final void putInt(String key, int value) {
        this.preferences.putInt(key, value);
    }

    public final void putBoolean(String key, boolean value) {
        this.preferences.putBoolean(key, value);
    }

    public final String get(String key, String defaultValue) {
        return this.preferences.get(key, defaultValue);
    }

    public final int getInt(String key, int defaultValue) {
        return this.preferences.getInt(key, defaultValue);
    }

    public final boolean getBoolean(String key, boolean defaultValue) {
        return this.preferences.getBoolean(key, defaultValue);
    }

    public final void flush() {
        try {
            this.preferences.flush();
            return;
        }
        catch (BackingStoreException backingStoreException) {
            BackingStoreException exception = backingStoreException;
            backingStoreException.printStackTrace();
            return;
        }
    }
}

