/*
 * Decompiled with CFR 0.152.
 */
package de.jave.swing.tabbedpane;

import de.jave.swing.tabbedpane.CloseIcon;
import de.jave.swing.tabbedpane.SmartTabbedPane;
import de.jave.swing.tabbedpane.TabButtonState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public final class SmartTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Color whiteColor = SystemColor.activeCaptionText;
    private static final Color transparent = new Color(0, 0, 0, 0);
    private static final Color selectedColor = SystemColor.activeCaption;
    private static final Color lightSelectedColor = new Color(selectedColor.getRed(), selectedColor.getGreen(), selectedColor.getBlue(), 50);
    private static final Icon CLOSE_ICON = new CloseIcon();
    private ContainerListener containerListener;
    private Vector htmlViews;
    private Hashtable mnemonicToIndexMap;
    private InputMap mnemonicInputMap;
    private ScrollableTabSupport tabScroller;
    private int tabCount;
    private MyMouseMotionListener motionListener;
    private static final Dimension BUTTONSIZE = new Dimension(15, 15);
    private static final Border PRESSEDBORDER = new BevelBorder(1);
    private static final Border OVERBORDER = new BevelBorder(0);
    private JButton closeButton;
    private int overTabIndex = -1;
    private TabButtonState closeIndexStatus = TabButtonState.INACTIVE;
    private boolean mousePressed = false;
    private boolean isCloseButtonEnabled = true;

    public SmartTabbedPaneUI() {
        this.closeButton = new JButton();
        this.closeButton.setSize(BUTTONSIZE);
    }

    protected final void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected final int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        int delta = 2;
        if (!this.isCloseButtonEnabled) {
            delta += 6;
        } else if (this.isCloseButtonEnabled) {
            delta = 2 + (SmartTabbedPaneUI.BUTTONSIZE.width + 4);
        }
        return super.calculateTabWidth(tabPlacement, tabIndex, metrics) + delta;
    }

    protected final int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight) + 5;
    }

    protected final void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 2, 0, 0, tabRect, iconRect, textRect, this.textIconGap);
        this.tabPane.putClientProperty("html", null);
        iconRect.x = tabRect.x + 8;
        textRect.x = iconRect.x + iconRect.width + this.textIconGap;
    }

    protected final MouseListener createMouseListener() {
        return new MyMouseHandler();
    }

    private Rectangle newCloseRect(Rectangle rect) {
        int dx = rect.x + rect.width;
        int dy = (rect.y + rect.height) / 2 - 6;
        return new Rectangle(dx - SmartTabbedPaneUI.BUTTONSIZE.width - 4, dy, SmartTabbedPaneUI.BUTTONSIZE.width, SmartTabbedPaneUI.BUTTONSIZE.height);
    }

    private void updateOverTab(int x, int y) {
        this.overTabIndex = this.getTabAtLocation(x, y);
        if (this.overTabIndex != this.overTabIndex) {
            this.tabScroller.tabPanel.repaint();
        }
    }

    private void updateCloseIcon(int x, int y) {
        if (this.overTabIndex != -1) {
            TabButtonState newCloseIndexStatus = TabButtonState.INACTIVE;
            Rectangle closeRect = this.newCloseRect(this.rects[this.overTabIndex]);
            if (closeRect.contains(x, y)) {
                TabButtonState tabButtonState = newCloseIndexStatus = this.mousePressed ? TabButtonState.PRESSED : TabButtonState.OVER;
            }
            if ((this.closeIndexStatus = newCloseIndexStatus) != this.closeIndexStatus) {
                this.tabScroller.tabPanel.repaint();
            }
        }
    }

    private void setTabIcons(int x, int y) {
        if (!this.mousePressed) {
            this.updateOverTab(x, y);
        }
        if (this.isCloseButtonEnabled) {
            this.updateCloseIcon(x, y);
        }
    }

    public static final ComponentUI createUI(JComponent c) {
        return new SmartTabbedPaneUI();
    }

    protected final LayoutManager createLayoutManager() {
        return new TabbedPaneScrollLayout();
    }

    protected final void installComponents() {
        if (this.tabScroller == null) {
            this.tabScroller = new ScrollableTabSupport(this.tabPane.getTabPlacement());
            this.tabPane.add(this.tabScroller.viewport);
            this.tabPane.add(this.tabScroller.scrollForwardButton);
            this.tabPane.add(this.tabScroller.scrollBackwardButton);
        }
    }

    protected final void uninstallComponents() {
        this.tabPane.remove(this.tabScroller.viewport);
        this.tabPane.remove(this.tabScroller.scrollForwardButton);
        this.tabPane.remove(this.tabScroller.scrollBackwardButton);
        this.tabScroller = null;
    }

    protected final void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.tabChangeListener = this.createChangeListener()) != null) {
            this.tabPane.addChangeListener(this.tabChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tabScroller.tabPanel.addMouseListener(this.mouseListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tabPane.addFocusListener(this.focusListener);
        }
        this.containerListener = new ContainerHandler();
        this.tabPane.addContainerListener(this.containerListener);
        if (this.tabPane.getTabCount() > 0) {
            this.htmlViews = this.createHTMLVector();
        }
        this.motionListener = new MyMouseMotionListener();
        this.tabScroller.tabPanel.addMouseMotionListener(this.motionListener);
    }

    protected final void uninstallListeners() {
        if (this.mouseListener != null) {
            this.tabScroller.tabPanel.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.motionListener != null) {
            this.tabScroller.tabPanel.removeMouseMotionListener(this.motionListener);
            this.motionListener = null;
        }
        if (this.focusListener != null) {
            this.tabPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.containerListener != null) {
            this.tabPane.removeContainerListener(this.containerListener);
            this.containerListener = null;
            if (this.htmlViews != null) {
                this.htmlViews.removeAllElements();
                this.htmlViews = null;
            }
        }
        if (this.tabChangeListener != null) {
            this.tabPane.removeChangeListener(this.tabChangeListener);
            this.tabChangeListener = null;
        }
        if (this.propertyChangeListener != null) {
            this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    protected final ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected final void installKeyboardActions() {
        InputMap km = this.getMyInputMap(1);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, km);
        km = this.getMyInputMap(0);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, km);
        ActionMap am = this.createMyActionMap();
        SwingUtilities.replaceUIActionMap(this.tabPane, am);
        this.tabScroller.scrollForwardButton.setAction(am.get("scrollTabsForwardAction"));
        this.tabScroller.scrollBackwardButton.setAction(am.get("scrollTabsBackwardAction"));
    }

    final InputMap getMyInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("TabbedPane.ancestorInputMap");
        }
        if (condition == 0) {
            return (InputMap)UIManager.get("TabbedPane.focusInputMap");
        }
        return null;
    }

    final ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateNext", new NextAction());
        map.put("navigatePrevious", new PreviousAction());
        map.put("navigateRight", new RightAction());
        map.put("navigateLeft", new LeftAction());
        map.put("navigateUp", new UpAction());
        map.put("navigateDown", new DownAction());
        map.put("navigatePageUp", new PageUpAction());
        map.put("navigatePageDown", new PageDownAction());
        map.put("requestFocus", new RequestFocusAction());
        map.put("requestFocusForVisibleComponent", new RequestFocusForVisibleAction());
        map.put("setSelectedIndex", new SetSelectedIndexAction());
        map.put("scrollTabsForwardAction", new ScrollTabsForwardAction());
        map.put("scrollTabsBackwardAction", new ScrollTabsBackwardAction());
        return map;
    }

    protected final void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.tabPane, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, null);
        SwingUtilities.replaceUIInputMap(this.tabPane, 0, null);
    }

    private void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = this.tabPane.getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = this.tabPane.getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.addMnemonic(counter, mnemonic);
        }
    }

    private void resetMnemonics() {
        if (this.mnemonicToIndexMap != null) {
            this.mnemonicToIndexMap.clear();
            this.mnemonicInputMap.clear();
        }
    }

    private void addMnemonic(int index, int mnemonic) {
        if (this.mnemonicToIndexMap == null) {
            this.initMnemonics();
        }
        this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        this.mnemonicToIndexMap.put(new Integer(mnemonic), new Integer(index));
    }

    private void initMnemonics() {
        this.mnemonicToIndexMap = new Hashtable();
        this.mnemonicInputMap = new InputMapUIResource();
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(this.tabPane, 1));
        SwingUtilities.replaceUIInputMap(this.tabPane, 1, this.mnemonicInputMap);
    }

    public final void paint(Graphics g, JComponent c) {
        int tc = this.tabPane.getTabCount();
        if (this.tabCount != tc) {
            this.tabCount = tc;
            this.updateMnemonics();
        }
        int selectedIndex = this.tabPane.getSelectedIndex();
        int tabPlacement = this.tabPane.getTabPlacement();
        this.ensureCurrentLayout();
        this.paintContentBorder(g, tabPlacement, selectedIndex);
    }

    protected final void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        Rectangle tabRect = rects[tabIndex];
        int selectedIndex = this.tabPane.getSelectedIndex();
        boolean isSelected = selectedIndex == tabIndex;
        boolean isOver = this.overTabIndex == tabIndex;
        Graphics2D g2 = null;
        Shape save = null;
        boolean cropShape = false;
        int cropx = 0;
        int cropy = 0;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            Rectangle viewRect = this.tabScroller.viewport.getViewRect();
            int cropline = viewRect.x + viewRect.width;
            if (tabRect.x < cropline && tabRect.x + tabRect.width > cropline) {
                cropx = cropline - 1;
                cropy = tabRect.y;
                cropShape = true;
            }
            if (cropShape) {
                save = g2.getClip();
                g2.clipRect(tabRect.x, tabRect.y, tabRect.width, tabRect.height);
            }
        }
        this.paintTabBackground(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, tabRect.x, tabRect.y, tabRect.width, tabRect.height, isSelected);
        String title = this.tabPane.getTitleAt(tabIndex);
        Font font = this.tabPane.getFont();
        FontMetrics metrics = g.getFontMetrics(font);
        Icon icon = this.getIconForTab(tabIndex);
        this.layoutLabel(tabPlacement, metrics, tabIndex, title, icon, tabRect, iconRect, textRect, isSelected);
        this.paintText(g, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
        this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        if (cropShape) {
            this.paintCroppedTabEdge(g, tabPlacement, tabIndex, isSelected, cropx, cropy);
            g2.setClip(save);
            return;
        }
        if (isOver || isSelected) {
            int dx = tabRect.x + tabRect.width - SmartTabbedPaneUI.BUTTONSIZE.width - 4;
            int dy = (tabRect.y + tabRect.height) / 2 - 5;
            if (this.isCloseButtonEnabled) {
                int iconDx = isOver && this.closeIndexStatus == TabButtonState.PRESSED ? 1 : 0;
                int iconDy = isOver && this.closeIndexStatus == TabButtonState.PRESSED ? 1 : 0;
                this.paintActionButton(g2, dx, dy, this.closeIndexStatus, isOver, this.closeButton);
                CLOSE_ICON.paintIcon(this.closeButton, g2, dx + 2 + iconDx, dy + 3 + iconDy);
            }
        }
    }

    private void paintActionButton(Graphics g, int dx, int dy, TabButtonState status, boolean isOver, JButton button) {
        button.setBorder(null);
        if (isOver) {
            if (status == TabButtonState.OVER) {
                button.setBorder(OVERBORDER);
            } else if (status == TabButtonState.PRESSED) {
                button.setBorder(PRESSEDBORDER);
            }
        }
        button.setBackground(this.tabScroller.tabPanel.getBackground());
        button.setOpaque(isOver && (status == TabButtonState.OVER || status == TabButtonState.PRESSED));
        g.translate(dx, dy);
        button.paint(g);
        g.translate(-dx, -dy);
    }

    private void paintCroppedTabEdge(Graphics g, int tabPlacement, int tabIndex, boolean isSelected, int x, int y) {
        g.setColor(this.shadow);
        g.drawLine(x, y, x, y + this.rects[tabIndex].height);
    }

    private void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout();
            layout.calculateLayoutInfo();
        }
    }

    protected final Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.width = this.rects[tabIndex].width;
        dest.height = this.rects[tabIndex].height;
        Point vpp = this.tabScroller.viewport.getLocation();
        Point viewp = this.tabScroller.viewport.getViewPosition();
        dest.x = this.rects[tabIndex].x + vpp.x - viewp.x;
        dest.y = this.rects[tabIndex].y + vpp.y - viewp.y;
        return dest;
    }

    private int getTabAtLocation(int x, int y) {
        this.ensureCurrentLayout();
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            if (!this.rects[i].contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    private int getClosestTab(int x, int y) {
        int want;
        int tabCount;
        int min = 0;
        int max = tabCount = Math.min(this.rects.length, this.tabPane.getTabCount());
        int tabPlacement = this.tabPane.getTabPlacement();
        boolean useX = tabPlacement == 1 || tabPlacement == 3;
        int n = want = useX ? x : y;
        while (min != max) {
            int maxLoc;
            int minLoc;
            int current = (max + min) / 2;
            if (useX) {
                minLoc = this.rects[current].x;
                maxLoc = minLoc + this.rects[current].width;
            } else {
                minLoc = this.rects[current].y;
                maxLoc = minLoc + this.rects[current].height;
            }
            if (want < minLoc) {
                max = current;
                if (min != max) continue;
                return Math.max(0, current - 1);
            }
            if (want >= maxLoc) {
                min = current;
                if (max - min > 1) continue;
                return Math.max(current + 1, tabCount - 1);
            }
            return current;
        }
        return min;
    }

    final boolean requestMyFocusForVisibleComponent() {
        Component visibleComponent = this.getVisibleComponent();
        if (visibleComponent.isFocusTraversable()) {
            visibleComponent.requestFocus();
            return true;
        }
        return visibleComponent instanceof JComponent && ((JComponent)visibleComponent).requestDefaultFocus();
    }

    private Vector createHTMLVector() {
        Vector<View> htmlViews = new Vector<View>();
        int count = this.tabPane.getTabCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                String title = this.tabPane.getTitleAt(i);
                if (BasicHTML.isHTMLString(title)) {
                    htmlViews.addElement(BasicHTML.createHTMLView(this.tabPane, title));
                    continue;
                }
                htmlViews.addElement(null);
            }
        }
        return htmlViews;
    }

    protected final void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        g.setColor(this.shadow);
        g.drawLine(x, y + 2, x, y + h - 1);
        g.drawLine(x + 1, y + 1, x + 1, y + 1);
        g.drawLine(x + 2, y, x + w - 3, y);
        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
        if (isSelected) {
            g.setColor(this.lightHighlight);
            g.drawLine(x + 2, y + 2, x + 2, y + h - 1);
            g.drawLine(x + 3, y + 1, x + w - 3, y + 1);
            g.drawLine(x + w - 3, y + 2, x + w - 3, y + 2);
            g.drawLine(x + w - 2, y + 2, x + w - 2, y + h - 1);
        }
    }

    protected final void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.shadow);
        g.drawLine(x, y, x + w - 2, y);
    }

    protected final void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.shadow);
        g.drawLine(x, y, x, y + h - 3);
    }

    protected final void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.shadow);
        g.drawLine(x + 1, y + h - 3, x + w - 2, y + h - 3);
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.setColor(this.shadow.brighter());
        g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
    }

    protected final void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(this.shadow);
        g.drawLine(x + w - 3, y + 1, x + w - 3, y + h - 3);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 3);
        g.setColor(this.shadow.brighter());
        g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 2);
    }

    protected final void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            Color startColor;
            Color endColor;
            boolean delta = false;
            boolean delta2 = false;
            if (this.tabPane.isEnabledAt(tabIndex)) {
                endColor = lightSelectedColor;
                startColor = selectedColor;
            } else {
                endColor = transparent;
                startColor = lightSelectedColor;
            }
            GradientPaint gradient = new GradientPaint(x + 2, y, startColor, x + w - 4, y, endColor);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(gradient);
            g2.fillRect(x + 2, y + 2, w - 4, h - 2);
        }
    }

    protected final void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
            return;
        }
        int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
        if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
            if (isSelected) {
                g.setColor(whiteColor);
            } else {
                g.setColor(this.tabPane.getForegroundAt(tabIndex));
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            return;
        }
        g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
        g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
        BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
    }

    private ScrollableTabButton createScrollableTabButton(int direction) {
        return new ScrollableTabButton(direction);
    }

    private final class ScrollableTabButton
    extends BasicArrowButton
    implements UIResource,
    SwingConstants {
        public ScrollableTabButton(int direction) {
            super(direction, UIManager.getColor("TabbedPane.selected"), UIManager.getColor("TabbedPane.shadow"), UIManager.getColor("TabbedPane.darkShadow"), UIManager.getColor("TabbedPane.highlight"));
            this.setRolloverEnabled(true);
        }

        public final boolean scrollsForward() {
            return this.direction == 3 || this.direction == 5;
        }

        public final Dimension getPreferredSize() {
            return new Dimension(16, SmartTabbedPaneUI.this.calculateMaxTabHeight(0));
        }

        public final void paint(Graphics g) {
            int w = this.getSize().width;
            int h = this.getSize().height;
            Color origColor = g.getColor();
            boolean isPressed = this.getModel().isPressed();
            boolean isRollOver = this.getModel().isRollover();
            boolean isEnabled = this.isEnabled();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, w, h);
            g.setColor(SmartTabbedPaneUI.this.shadow);
            if (this.direction == 7) {
                g.drawLine(0, 0, 0, h - 1);
                g.drawLine(w - 1, 0, w - 1, 0);
            } else {
                g.drawLine(w - 2, h - 1, w - 2, 0);
            }
            g.drawLine(0, 0, w - 2, 0);
            if (isRollOver) {
                Color color1;
                Color color2;
                if (isPressed) {
                    color2 = whiteColor;
                    color1 = SmartTabbedPaneUI.this.shadow;
                } else {
                    color1 = whiteColor;
                    color2 = SmartTabbedPaneUI.this.shadow;
                }
                g.setColor(color1);
                if (this.direction == 7) {
                    g.drawLine(1, 1, 1, h - 1);
                    g.drawLine(1, 1, w - 2, 1);
                    g.setColor(color2);
                    g.drawLine(w - 1, h - 1, w - 1, 1);
                } else {
                    g.drawLine(0, 1, 0, h - 1);
                    g.drawLine(0, 1, w - 3, 1);
                    g.setColor(color2);
                    g.drawLine(w - 3, h - 1, w - 3, 1);
                }
            }
            if (h < 5 || w < 5) {
                g.setColor(origColor);
                return;
            }
            if (isPressed) {
                g.translate(1, 1);
            }
            int size = Math.min((h - 4) / 3, (w - 4) / 3);
            size = Math.max(size, 2);
            this.paintTriangle(g, (w - size) / 2, (h - size) / 2, size, this.direction, isEnabled);
            if (isPressed) {
                g.translate(-1, -1);
            }
            g.setColor(origColor);
        }
    }

    private final class MyMouseMotionListener
    implements MouseMotionListener {
        private MyMouseMotionListener() {
        }

        public final void mouseMoved(MouseEvent e) {
            SmartTabbedPaneUI.this.mousePressed = false;
            SmartTabbedPaneUI.this.setTabIcons(e.getX(), e.getY());
        }

        public final void mouseDragged(MouseEvent e) {
            SmartTabbedPaneUI.this.mousePressed = true;
            SmartTabbedPaneUI.this.setTabIcons(e.getX(), e.getY());
        }
    }

    private final class MyMouseHandler
    extends BasicTabbedPaneUI.MouseHandler {
        public MyMouseHandler() {
            super(SmartTabbedPaneUI.this);
        }

        public final void mousePressed(MouseEvent e) {
            if (SmartTabbedPaneUI.this.closeIndexStatus == TabButtonState.OVER) {
                SmartTabbedPaneUI.this.closeIndexStatus = TabButtonState.PRESSED;
                ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).tabScroller.tabPanel.repaint();
                return;
            }
        }

        public final void mouseClicked(MouseEvent e) {
            super.mousePressed(e);
            if (e.getClickCount() == 2 && SmartTabbedPaneUI.this.overTabIndex != -1) {
                ((SmartTabbedPane)SmartTabbedPaneUI.this.tabPane).fireDoubleClickTabEvent(e, SmartTabbedPaneUI.this.overTabIndex);
            }
        }

        public final void mouseReleased(MouseEvent e) {
            SmartTabbedPaneUI.this.updateOverTab(e.getX(), e.getY());
            if (e.isMetaDown() && SmartTabbedPaneUI.this.overTabIndex != -1) {
                ((SmartTabbedPane)SmartTabbedPaneUI.this.tabPane).popupOnTabEvent(SmartTabbedPaneUI.this.overTabIndex, e.getPoint());
                if (SmartTabbedPaneUI.this.closeIndexStatus == TabButtonState.PRESSED) {
                    SmartTabbedPaneUI.this.closeIndexStatus = TabButtonState.OVER;
                    ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).tabScroller.tabPanel.repaint();
                }
                return;
            }
            if (SmartTabbedPaneUI.this.isCloseButtonEnabled && e.isPopupTrigger()) {
                super.mousePressed(e);
                SmartTabbedPaneUI.this.closeIndexStatus = TabButtonState.INACTIVE;
                return;
            }
            if (SmartTabbedPaneUI.this.closeIndexStatus == TabButtonState.PRESSED) {
                SmartTabbedPaneUI.this.closeIndexStatus = TabButtonState.OVER;
                ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).tabScroller.tabPanel.repaint();
                ((SmartTabbedPane)SmartTabbedPaneUI.this.tabPane).fireTabClosing(SmartTabbedPaneUI.this.overTabIndex);
                return;
            }
            if (SmartTabbedPaneUI.this.overTabIndex != -1) {
                SmartTabbedPaneUI.this.tabPane.setSelectedIndex(SmartTabbedPaneUI.this.overTabIndex);
            }
        }

        public final void mouseExited(MouseEvent e) {
            if (!SmartTabbedPaneUI.this.mousePressed) {
                SmartTabbedPaneUI.this.overTabIndex = -1;
                ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).tabScroller.tabPanel.repaint();
            }
        }
    }

    private final class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public final void componentAdded(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            int index = tp.indexOfComponent(child);
            String title = tp.getTitleAt(index);
            boolean isHTML = BasicHTML.isHTMLString(title);
            if (isHTML) {
                if (SmartTabbedPaneUI.this.htmlViews == null) {
                    SmartTabbedPaneUI.this.htmlViews = SmartTabbedPaneUI.this.createHTMLVector();
                    return;
                }
                View v = BasicHTML.createHTMLView(tp, title);
                SmartTabbedPaneUI.this.htmlViews.insertElementAt(v, index);
                return;
            }
            if (SmartTabbedPaneUI.this.htmlViews != null) {
                SmartTabbedPaneUI.this.htmlViews.insertElementAt(null, index);
            }
        }

        public final void componentRemoved(ContainerEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getContainer();
            Component child = e.getChild();
            if (child instanceof UIResource) {
                return;
            }
            Integer indexObj = (Integer)tp.getClientProperty("__index_to_remove__");
            if (indexObj != null) {
                int index = indexObj;
                if (SmartTabbedPaneUI.this.htmlViews != null && SmartTabbedPaneUI.this.htmlViews.size() >= index) {
                    SmartTabbedPaneUI.this.htmlViews.removeElementAt(index);
                }
            }
        }
    }

    public final class TabSelectionHandler
    implements ChangeListener {
        public final void stateChanged(ChangeEvent e) {
            int index;
            JTabbedPane tabPane = (JTabbedPane)e.getSource();
            tabPane.revalidate();
            tabPane.repaint();
            if (tabPane.getTabLayoutPolicy() == 1 && (index = tabPane.getSelectedIndex()) < SmartTabbedPaneUI.this.rects.length && index != -1) {
                ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).tabScroller.tabPanel.scrollRectToVisible(SmartTabbedPaneUI.this.rects[index]);
            }
        }
    }

    private final class ScrollableTabPanel
    extends JPanel
    implements UIResource {
        public ScrollableTabPanel() {
            this.setLayout(null);
        }

        public final void paintComponent(Graphics g) {
            super.paintComponent(g);
            SmartTabbedPaneUI.this.paintTabArea(g, SmartTabbedPaneUI.this.tabPane.getTabPlacement(), SmartTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    private final class ScrollableTabViewport
    extends JViewport
    implements UIResource {
        public ScrollableTabViewport(SmartTabbedPaneUI this$0) {
            this.setScrollMode(0);
        }
    }

    private final class ScrollableTabSupport
    implements ChangeListener {
        public ScrollableTabViewport viewport;
        public ScrollableTabPanel tabPanel;
        public ScrollableTabButton scrollForwardButton;
        public ScrollableTabButton scrollBackwardButton;
        public int leadingTabIndex;
        private Point tabViewPosition = new Point(0, 0);

        ScrollableTabSupport(int tabPlacement) {
            this.viewport = new ScrollableTabViewport(SmartTabbedPaneUI.this);
            this.tabPanel = new ScrollableTabPanel();
            this.viewport.setView(this.tabPanel);
            this.viewport.addChangeListener(this);
            this.scrollForwardButton = SmartTabbedPaneUI.this.createScrollableTabButton(3);
            this.scrollBackwardButton = SmartTabbedPaneUI.this.createScrollableTabButton(7);
        }

        public final void scrollForward(int tabPlacement) {
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            if (tabPlacement == 1 || tabPlacement == 3 ? viewRect.width >= viewSize.width - viewRect.x : viewRect.height >= viewSize.height - viewRect.y) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex + 1);
        }

        public final void scrollBackward(int tabPlacement) {
            if (this.leadingTabIndex == 0) {
                return;
            }
            this.setLeadingTabIndex(tabPlacement, this.leadingTabIndex - 1);
        }

        public final void setLeadingTabIndex(int tabPlacement, int index) {
            this.leadingTabIndex = index;
            Dimension viewSize = this.viewport.getViewSize();
            Rectangle viewRect = this.viewport.getViewRect();
            int n = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).rects[this.leadingTabIndex].x;
            if (viewSize.width - this.tabViewPosition.x < viewRect.width) {
                Dimension extentSize = new Dimension(viewSize.width - this.tabViewPosition.x, viewRect.height);
                this.viewport.setExtentSize(extentSize);
            }
            this.viewport.setViewPosition(this.tabViewPosition);
        }

        public final void stateChanged(ChangeEvent e) {
            JViewport viewport = (JViewport)e.getSource();
            int tabPlacement = SmartTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = SmartTabbedPaneUI.this.tabPane.getTabCount();
            Rectangle vpRect = viewport.getBounds();
            Dimension viewSize = viewport.getViewSize();
            Rectangle viewRect = viewport.getViewRect();
            this.leadingTabIndex = SmartTabbedPaneUI.this.getClosestTab(viewRect.x, viewRect.y);
            if (this.leadingTabIndex + 1 < tabCount && ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).rects[this.leadingTabIndex].x < viewRect.x) {
                ++this.leadingTabIndex;
            }
            Insets contentInsets = SmartTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
            SmartTabbedPaneUI.this.tabPane.repaint(vpRect.x, vpRect.y + vpRect.height, vpRect.width, contentInsets.top);
            this.scrollBackwardButton.setEnabled(viewRect.x > 0);
            this.scrollForwardButton.setEnabled(this.leadingTabIndex < tabCount - 1 && viewSize.width - viewRect.x > viewRect.width);
        }

        public final String toString() {
            return new String("viewport.viewSize=" + this.viewport.getViewSize() + "\n" + "viewport.viewRectangle=" + this.viewport.getViewRect() + "\n" + "leadingTabIndex=" + this.leadingTabIndex + "\n" + "tabViewPosition=" + this.tabViewPosition);
        }
    }

    private final class TabbedPaneScrollLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        private TabbedPaneScrollLayout() {
            super(SmartTabbedPaneUI.this);
        }

        protected final int preferredTabAreaHeight(int tabPlacement, int width) {
            return SmartTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        protected final int preferredTabAreaWidth(int tabPlacement, int height) {
            return SmartTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        public final void layoutContainer(Container parent) {
            int tabPlacement = SmartTabbedPaneUI.this.tabPane.getTabPlacement();
            int tabCount = SmartTabbedPaneUI.this.tabPane.getTabCount();
            Insets insets = SmartTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = SmartTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = SmartTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    SmartTabbedPaneUI.this.setVisibleComponent(null);
                    return;
                }
            } else {
                Component selectedComponent = SmartTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                boolean shouldChangeFocus = false;
                if (selectedComponent != null) {
                    if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                        shouldChangeFocus = true;
                    }
                    SmartTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Insets contentInsets = SmartTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Rectangle bounds = SmartTabbedPaneUI.this.tabPane.getBounds();
                int numChildren = SmartTabbedPaneUI.this.tabPane.getComponentCount();
                if (numChildren > 0) {
                    int tw = bounds.width - insets.left - insets.right;
                    int th = SmartTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, SmartTabbedPaneUI.this.runCount, SmartTabbedPaneUI.this.maxTabHeight);
                    int tx = insets.left;
                    int ty = insets.top;
                    int cx = tx + contentInsets.left;
                    int cy = ty + th + contentInsets.top;
                    int cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    int ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    for (int i = 0; i < numChildren; ++i) {
                        Component child = SmartTabbedPaneUI.this.tabPane.getComponent(i);
                        if (child instanceof ScrollableTabViewport) {
                            JViewport viewport = (JViewport)child;
                            Rectangle viewRect = viewport.getViewRect();
                            int vw = tw;
                            int vh = th;
                            int totalTabWidth = ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).rects[tabCount - 1].x + ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).rects[tabCount - 1].width;
                            if (totalTabWidth > tw && totalTabWidth - viewRect.x <= (vw = Math.max(tw - 36, 36))) {
                                vw = totalTabWidth - viewRect.x;
                            }
                            child.setBounds(tx, ty, vw, vh);
                            continue;
                        }
                        if (child instanceof ScrollableTabButton) {
                            ScrollableTabButton scrollbutton = (ScrollableTabButton)child;
                            Dimension bsize = scrollbutton.getPreferredSize();
                            int bx = 0;
                            int by = 0;
                            int bw = bsize.width;
                            int bh = bsize.height;
                            boolean visible = false;
                            int totalTabWidth = ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).rects[tabCount - 1].x + ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).rects[tabCount - 1].width;
                            if (totalTabWidth > tw) {
                                int dir = scrollbutton.scrollsForward() ? 3 : 7;
                                scrollbutton.setDirection(dir);
                                visible = true;
                                bx = dir == 3 ? bounds.width - insets.left - bsize.width : bounds.width - insets.left - 2 * bsize.width;
                                by = tabPlacement == 1 ? ty + th - bsize.height : ty;
                            }
                            child.setVisible(visible);
                            if (!visible) continue;
                            child.setBounds(bx, by, bw, bh);
                            continue;
                        }
                        child.setBounds(cx, cy, cw, ch);
                    }
                    if (shouldChangeFocus && !SmartTabbedPaneUI.this.requestMyFocusForVisibleComponent()) {
                        SmartTabbedPaneUI.this.tabPane.requestFocus();
                    }
                }
            }
        }

        protected final void calculateTabRects(int tabPlacement, int tabCount) {
            FontMetrics metrics = SmartTabbedPaneUI.this.getFontMetrics();
            SmartTabbedPaneUI.this.tabPane.getSize();
            SmartTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = SmartTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            metrics.getHeight();
            SmartTabbedPaneUI.this.tabPane.getSelectedIndex();
            int x = tabAreaInsets.left - 2;
            int y = tabAreaInsets.top;
            int totalWidth = 0;
            int totalHeight = 0;
            SmartTabbedPaneUI.this.maxTabHeight = SmartTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            SmartTabbedPaneUI.this.runCount = 0;
            SmartTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            SmartTabbedPaneUI.this.selectedRun = 0;
            SmartTabbedPaneUI.this.runCount = 1;
            for (int i = 0; i < tabCount; ++i) {
                Rectangle rect = SmartTabbedPaneUI.this.rects[i];
                if (i > 0) {
                    rect.x = ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).rects[i - 1].x + ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).rects[i - 1].width - 1;
                } else {
                    ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).tabRuns[0] = 0;
                    SmartTabbedPaneUI.this.maxTabWidth = 0;
                    totalHeight += SmartTabbedPaneUI.this.maxTabHeight;
                    rect.x = x;
                }
                rect.width = SmartTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                totalWidth = rect.x + rect.width;
                SmartTabbedPaneUI.this.maxTabWidth = Math.max(SmartTabbedPaneUI.this.maxTabWidth, rect.width);
                rect.y = y;
                rect.height = SmartTabbedPaneUI.this.maxTabHeight;
            }
            ((SmartTabbedPaneUI)SmartTabbedPaneUI.this).tabScroller.tabPanel.setPreferredSize(new Dimension(totalWidth, totalHeight));
        }
    }

    private static final class ScrollTabsBackwardAction
    extends AbstractAction {
        private ScrollTabsBackwardAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.tabScroller.scrollBackward(pane.getTabPlacement());
        }
    }

    private static final class ScrollTabsForwardAction
    extends AbstractAction {
        private ScrollTabsForwardAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = null;
            Object src = e.getSource();
            if (src instanceof JTabbedPane) {
                pane = (JTabbedPane)src;
            } else if (src instanceof ScrollableTabButton) {
                pane = (JTabbedPane)((ScrollableTabButton)src).getParent();
            } else {
                return;
            }
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.tabScroller.scrollForward(pane.getTabPlacement());
        }
    }

    private static final class SetSelectedIndexAction
    extends AbstractAction {
        private SetSelectedIndexAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            if (pane != null && pane.getUI() instanceof SmartTabbedPaneUI) {
                SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    Integer index;
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    if ((index = (Integer)ui.mnemonicToIndexMap.get(new Integer(mnemonic))) != null && pane.isEnabledAt(index)) {
                        pane.setSelectedIndex(index);
                    }
                }
            }
        }
    }

    private static final class RequestFocusForVisibleAction
    extends AbstractAction {
        private RequestFocusForVisibleAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.requestMyFocusForVisibleComponent();
        }
    }

    private static final class RequestFocusAction
    extends AbstractAction {
        private RequestFocusAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            pane.requestFocus();
        }
    }

    private static final class PageDownAction
    extends AbstractAction {
        private PageDownAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(3);
                return;
            }
            ui.navigateSelectedTab(5);
        }
    }

    private static final class PageUpAction
    extends AbstractAction {
        private PageUpAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            int tabPlacement = pane.getTabPlacement();
            if (tabPlacement == 1 || tabPlacement == 3) {
                ui.navigateSelectedTab(7);
                return;
            }
            ui.navigateSelectedTab(1);
        }
    }

    private static final class PreviousAction
    extends AbstractAction {
        private PreviousAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(13);
        }
    }

    private static final class NextAction
    extends AbstractAction {
        private NextAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(12);
        }
    }

    private static final class DownAction
    extends AbstractAction {
        private DownAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(5);
        }
    }

    private static final class UpAction
    extends AbstractAction {
        private UpAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(1);
        }
    }

    private static final class LeftAction
    extends AbstractAction {
        private LeftAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(7);
        }
    }

    private static final class RightAction
    extends AbstractAction {
        private RightAction() {
        }

        public final void actionPerformed(ActionEvent e) {
            JTabbedPane pane = (JTabbedPane)e.getSource();
            SmartTabbedPaneUI ui = (SmartTabbedPaneUI)pane.getUI();
            ui.navigateSelectedTab(3);
        }
    }
}

