/*
 * Decompiled with CFR 0.152.
 */
package de.jave.text;

import java.awt.Dimension;

public final class TextTools {
    private TextTools() {
    }

    public static final int count(String s, char ch) {
        int result = 0;
        int index = s.indexOf(ch);
        while (index != -1) {
            ++result;
            index = s.indexOf(ch, index + 1);
        }
        return result;
    }

    public static final String fillFront(String text, char fill, int length) {
        while (text.length() < length) {
            text = fill + text;
        }
        return text;
    }

    public static final String firstLetterUp(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        char[] cArray = text.toCharArray();
        char[] chars = cArray;
        cArray[0] = Character.toUpperCase(chars[0]);
        for (int i = 0; i < chars.length - 1; ++i) {
            if (chars[i] != ' ') continue;
            chars[i + 1] = Character.toUpperCase(chars[i + 1]);
        }
        return new String(chars);
    }

    public static final String[] toStringArray(char[][] ch) {
        int height = ch.length;
        String[] result = new String[height];
        for (int y = 0; y < height; ++y) {
            result[y] = TextTools.trimRight(new String(ch[y]));
        }
        return result;
    }

    public static final String trimRight(String line) {
        int i0;
        for (i0 = line.length() - 1; i0 >= 0 && line.charAt(i0) <= ' '; --i0) {
        }
        return line.substring(0, i0 + 1);
    }

    public static final String toString(char[][] ch) {
        int height = ch.length;
        int width = height == 0 ? 0 : ch[0].length;
        StringBuffer sb = new StringBuffer(height * width + height);
        for (int y = 0; y < height; ++y) {
            sb.append(TextTools.trimRight(new String(ch[y])));
            if (y >= height - 1) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static final Dimension getDimensionOf(String text) {
        int h = 1;
        int w = 0;
        int currentW = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                if (currentW > w) {
                    w = currentW;
                }
                currentW = 0;
                ++h;
                continue;
            }
            ++currentW;
        }
        if (currentW > w) {
            w = currentW;
        }
        return new Dimension(w, h);
    }

    public static final char[][] toCharField(String[] lines) {
        int h = lines.length;
        int w = 0;
        for (int y = 0; y < h; ++y) {
            if (lines[y].length() <= w) continue;
            w = lines[y].length();
        }
        char[][] ch = new char[h][w];
        for (int y = 0; y < h; ++y) {
            int x;
            for (x = 0; x < lines[y].length(); ++x) {
                ch[y][x] = lines[y].charAt(x);
            }
            for (x = lines[y].length(); x < w; ++x) {
                ch[y][x] = 32;
            }
        }
        return ch;
    }

    public static final char[][] toCharField(String text) {
        Dimension d = TextTools.getDimensionOf(text);
        if (d.width == 0 && d.height > 0) {
            d.width = 1;
        } else if (d.height == 0 && d.width > 0) {
            d.height = 1;
        }
        char[][] ch = new char[d.height][d.width];
        int y = 0;
        int x = 0;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) == '\n') {
                for (int xx = x; xx < d.width; ++xx) {
                    ch[y][xx] = 32;
                }
                x = 0;
                ++y;
                continue;
            }
            ch[y][x] = text.charAt(i);
            ++x;
        }
        for (int xx = x; xx < d.width; ++xx) {
            ch[y][xx] = 32;
        }
        return ch;
    }

    public static final String[] toStringArray(String text) {
        Dimension d = TextTools.getDimensionOf(text);
        if (d.height <= 1) {
            return new String[]{text};
        }
        String[] result = new String[d.height];
        int y = 0;
        int x1 = 0;
        int x2 = 0;
        int l = text.length();
        while (y < d.height) {
            while (x2 < l && text.charAt(x2) != '\n') {
                ++x2;
            }
            result[y++] = text.substring(x1, x2);
            x1 = x2 + 1;
            ++x2;
        }
        return result;
    }
}

