/*
 * Decompiled with CFR 0.152.
 */
package de.jave.undo;

import de.jave.jave.CompressedDocumentState;
import de.jave.undo.LogFile;
import de.jave.undo.UndoItem;

public final class UndoManager {
    private UndoItem currentItem;
    private UndoItem firstItem;
    private int maxSize;
    private LogFile logFile;

    public UndoManager(CompressedDocumentState initialState) {
        this.firstItem = this.currentItem = new UndoItem(initialState);
        this.logFile = null;
    }

    public final void setLogFile(LogFile logFile) {
        this.logFile = logFile;
    }

    public final LogFile getLogFile() {
        return this.logFile;
    }

    public final String getLogFileName() {
        if (this.logFile == null) {
            return null;
        }
        return this.logFile.getAbsolutePath();
    }

    public final boolean isLogging() {
        return this.logFile != null;
    }

    public final synchronized void saveCurrentState(CompressedDocumentState o) {
        UndoItem item;
        this.currentItem.next = item = new UndoItem(o);
        item.prev = this.currentItem;
        this.currentItem = item;
        this.ensureMaxSize();
        if (this.logFile != null) {
            this.logFile.append(o);
        }
    }

    public final synchronized boolean canUndo() {
        return this.currentItem.prev != null;
    }

    public final synchronized CompressedDocumentState undo() {
        this.currentItem = this.currentItem.prev;
        CompressedDocumentState result = this.currentItem.undoState;
        return result;
    }

    public final synchronized CompressedDocumentState getNextState() {
        if (this.currentItem.next == null) {
            return null;
        }
        return this.currentItem.next.undoState;
    }

    public final synchronized boolean canRedo() {
        return this.currentItem.next != null;
    }

    public final synchronized CompressedDocumentState redo() {
        this.currentItem = this.currentItem.next;
        CompressedDocumentState result = this.currentItem.undoState;
        return result;
    }

    public final synchronized String getUndoActionName() {
        String an = this.currentItem.getUndoActionName();
        if (an != null) {
            return an;
        }
        return "";
    }

    public final synchronized String getRedoActionName() {
        UndoItem nextItem = this.currentItem.next;
        if (nextItem == null) {
            return "";
        }
        String an = nextItem.getUndoActionName();
        if (an != null) {
            return an;
        }
        return "";
    }

    public final void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.ensureMaxSize();
    }

    protected final synchronized void ensureMaxSize() {
        if (this.maxSize <= 0) {
            return;
        }
        UndoItem item = this.firstItem;
        int size = 0;
        while (item != null) {
            size += item.getEstimatedMemorySize();
            item = item.next;
        }
        if (size <= this.maxSize) {
            return;
        }
        while (size > this.maxSize && this.currentItem != this.firstItem.next) {
            size -= this.firstItem.getEstimatedMemorySize();
            this.firstItem = this.firstItem.next;
            this.firstItem.prev = null;
        }
    }
}

