/*
 * Decompiled with CFR 0.152.
 */
package de.jave.util;

import de.jave.io.IOTools;
import de.jave.jave.Jave;
import de.jave.lib.gui.GuiUtilities;
import de.jave.preferences.SmartPreferences;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class RecentFileList
implements ActionListener {
    private final LinkedList files = new LinkedList();
    private JMenu menu;
    private Jave listener;
    private int maxSize;
    private final SmartPreferences preferences;

    public RecentFileList(SmartPreferences preferences) {
        Ensure.ensureArgumentNotNull(preferences);
        this.preferences = preferences;
        this.maxSize = preferences.getInt("maxFileCount", 5);
        int fileCount = preferences.getInt("fileCount", 0);
        for (int i = 0; i < fileCount; ++i) {
            String fileName = preferences.get("file" + i, null);
            File file = new File(fileName);
            this.files.add(file);
        }
    }

    public final void setRecentFileOpenListener(Jave listener) {
        this.listener = listener;
    }

    public final void add(File file) {
        this.delete(file);
        this.files.addFirst(file);
        if (this.files.size() > this.maxSize) {
            this.files.removeLast();
        }
        this.updateMenu();
    }

    public final void delete(File file) {
        this.files.remove(file);
        this.updateMenu();
    }

    public final void setMaxSize(int maxSize) {
        if (maxSize > 9) {
            maxSize = 9;
        }
        while (this.files.size() > maxSize) {
            this.files.removeLast();
        }
        this.maxSize = maxSize;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final File[] getFiles() {
        return this.files.toArray(new File[this.files.size()]);
    }

    public final File getFile(int index) {
        return (File)this.files.get(index);
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("-- " + this.files.size() + " Eint\u00e4ge in der History\n");
        for (int i = 0; i < this.files.size(); ++i) {
            File file = (File)this.files.get(i);
            sb.append(i + " " + file.getAbsolutePath() + "\n");
        }
        return sb.toString();
    }

    public final void setMenu(JMenu menu) {
        if (this.menu != null) {
            this.menu.removeAll();
        }
        this.menu = menu;
        this.updateMenu();
    }

    private void updateMenu() {
        if (this.menu == null) {
            return;
        }
        this.menu.removeAll();
        File[] f = this.getFiles();
        if (f.length == 0) {
            JMenuItem m = new JMenuItem("none");
            m.setEnabled(false);
            this.menu.add(m);
            return;
        }
        for (int i = 0; i < f.length; ++i) {
            JMenuItem mi = new JMenuItem(i + " " + IOTools.getDisplayFilename(f[i].toString(), 25));
            mi.addActionListener(this);
            this.menu.add(mi);
        }
    }

    public final void actionPerformed(ActionEvent evt) {
        if (this.listener == null) {
            return;
        }
        Window parentComponent = GuiUtilities.getWindowForComponent(evt);
        JMenuItem mi = (JMenuItem)evt.getSource();
        int menuSize = this.menu.getMenuComponentCount();
        for (int i = 0; i < menuSize; ++i) {
            if (this.menu.getMenuComponent(i) != mi) continue;
            File file = this.getFile(i);
            if (!file.exists()) {
                MessageDialogFactory.showMessageDialog(parentComponent, new Message("The file '" + file.getAbsolutePath() + "' does not exist.", MessageType.ERROR));
                this.delete(file);
                return;
            }
            this.listener.openRecentFile(parentComponent, file);
        }
    }

    public final void flush() {
        this.preferences.putInt("maxFileCount", this.maxSize);
        this.preferences.putInt("fileCount", this.files.size());
        for (int i = 0; i < this.files.size(); ++i) {
            File file = (File)this.files.get(i);
            this.preferences.put("file" + i, file.getAbsolutePath());
        }
        this.preferences.flush();
    }
}

