/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching;

import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs2_0BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs2_1BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs3_0BrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOs3_1BrowserLaunching;
import edu.stanford.ejalbert.launching.misc.UnixNetscapeBrowserLaunching;
import edu.stanford.ejalbert.launching.windows.Windows2000BrowserLaunching;
import edu.stanford.ejalbert.launching.windows.Windows9xBrowserLaunching;
import edu.stanford.ejalbert.launching.windows.WindowsNtBrowserLaunching;

public final class BrowserLaunchingFactory {
    public static final IBrowserLaunching createSystemBrowserLaunching() throws UnsupportedOperatingSystemException {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Mac OS")) {
            String mrjVersion = System.getProperty("mrj.version");
            String majorMRJVersion = mrjVersion.substring(0, 3);
            try {
                double version = Double.valueOf(majorMRJVersion);
                if (version == 2.0) {
                    return new MacOs2_0BrowserLaunching();
                }
                if (version >= 2.1 && version < 3.0) {
                    return new MacOs2_1BrowserLaunching();
                }
                if (version == 3.0) {
                    return new MacOs3_0BrowserLaunching();
                }
                if (version >= 3.1) {
                    return new MacOs3_1BrowserLaunching();
                }
                throw new UnsupportedOperatingSystemException("Unsupported MRJ version: " + version);
            }
            catch (NumberFormatException numberFormatException) {
                throw new UnsupportedOperatingSystemException("Invalid MRJ version: " + mrjVersion);
            }
        }
        if (osName.startsWith("Windows")) {
            if (osName.indexOf("9") != -1) {
                return new Windows9xBrowserLaunching();
            }
            if (osName.indexOf("2000") != -1) {
                return new Windows2000BrowserLaunching();
            }
            return new WindowsNtBrowserLaunching();
        }
        return new UnixNetscapeBrowserLaunching();
    }
}

