/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.macos;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import edu.stanford.ejalbert.launching.macos.MacOsBrowserLaunching;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class MacOs2_1BrowserLaunching
extends MacOsBrowserLaunching
implements IBrowserLaunching {
    private Object kSystemFolderType;
    private Method findFolder;
    private Method getFileCreator;
    private Method getFileType;
    private String browser;
    static /* synthetic */ Class class$java$io$File;

    public final void initialize() throws BrowserLaunchingInitializingException {
        try {
            Class<?> mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
            Class<?> mrjOSTypeClass = Class.forName("com.apple.mrj.MRJOSType");
            Field systemFolderField = mrjFileUtilsClass.getDeclaredField("kSystemFolderType");
            this.kSystemFolderType = systemFolderField.get(null);
            this.findFolder = mrjFileUtilsClass.getDeclaredMethod("findFolder", mrjOSTypeClass);
            this.getFileCreator = mrjFileUtilsClass.getDeclaredMethod("getFileCreator", class$java$io$File == null ? (class$java$io$File = MacOs2_1BrowserLaunching.class$("java.io.File")) : class$java$io$File);
            this.getFileType = mrjFileUtilsClass.getDeclaredMethod("getFileType", class$java$io$File == null ? (class$java$io$File = MacOs2_1BrowserLaunching.class$("java.io.File")) : class$java$io$File);
            return;
        }
        catch (Exception e) {
            throw new BrowserLaunchingInitializingException(e);
        }
    }

    private String getBrowser() throws BrowserLaunchingInitializingException {
        File systemFolder;
        if (this.browser != null) {
            return this.browser;
        }
        try {
            systemFolder = (File)this.findFolder.invoke(null, this.kSystemFolderType);
        }
        catch (Exception e) {
            throw new BrowserLaunchingInitializingException(e);
        }
        String[] systemFolderFiles = systemFolder.list();
        for (int i = 0; i < systemFolderFiles.length; ++i) {
            try {
                Object fileCreator;
                Object fileType;
                File file = new File(systemFolder, systemFolderFiles[i]);
                if (!file.isFile() || !"FNDR".equals((fileType = this.getFileType.invoke(null, file)).toString()) || !"MACS".equals((fileCreator = this.getFileCreator.invoke(null, file)).toString())) continue;
                this.browser = file.toString();
                return this.browser;
            }
            catch (Exception e) {
                throw new BrowserLaunchingInitializingException(e);
            }
        }
        throw new BrowserLaunchingInitializingException("Unable to find finder");
    }

    public final void openUrl(String urlString) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        String browser = this.getBrowser();
        try {
            Runtime.getRuntime().exec(new String[]{browser, urlString});
            return;
        }
        catch (IOException e) {
            throw new BrowserLaunchingExecutionException(e);
        }
    }

    static final /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

