/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.message;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IMessage;
import net.disy.commons.core.message.MessageType;

public final class Message
extends BasicMessage
implements IMessage {
    private final String title;
    private final String detailText;

    private Message(String title, String text, MessageType type, String detailText, Throwable throwable) {
        super(text, type);
        this.title = title;
        this.detailText = detailText;
    }

    public Message(String title, String text, MessageType type, Throwable throwable) {
        this(title, text, type, Message.getStackTrace(throwable), throwable);
    }

    private static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter stacktrace = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stacktrace));
        return stacktrace.toString();
    }

    public Message(String title, String text, Throwable throwable) {
        this(title, text, MessageType.ERROR, throwable);
    }

    public Message(String title, String text, MessageType type) {
        this(title, text, type, null);
    }

    public Message(String text, Throwable throwable) {
        this(null, text, throwable);
    }

    public Message(String text, MessageType type) {
        this(text, type, (String)null);
    }

    public Message(String text, MessageType messageType, String detailText) {
        this(null, text, messageType, detailText, null);
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getDetail() {
        return this.detailText;
    }
}

