/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.util;

import net.disy.commons.core.util.ContractFailedException;

public final class Ensure {
    protected Ensure() {
    }

    public static final void ensureNotNull(String message, Object object) {
        Ensure.ensureTrue(message, object != null);
    }

    public static final void ensureArgumentNotNull(String message, Object object) throws IllegalArgumentException {
        Ensure.ensureArgumentTrue(message, object != null);
    }

    public static final void ensureNotNull(Object object) {
        Ensure.ensureNotNull("Object must not be null", object);
    }

    public static final void ensureArgumentNotNull(Object object) throws IllegalArgumentException {
        Ensure.ensureArgumentNotNull("Object must not be null", object);
    }

    public static final void ensureArgumentTrue(boolean state) throws IllegalArgumentException {
        Ensure.ensureArgumentTrue("boolean must be true", state);
    }

    public static final void ensureTrue(String message, boolean state) {
        if (!state) {
            throw new ContractFailedException(message);
        }
    }

    public static final void ensureArgumentTrue(String message, boolean state) throws IllegalArgumentException {
        if (!state) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final void ensureArgumentArrayContentsNotNull(Object[] arguments) {
        Ensure.ensureArgumentArrayContentsNotNull("Array contents must not be null", arguments);
    }

    public static final void ensureArgumentArrayContentsNotNull(String message, Object[] arguments) {
        if (arguments == null) {
            return;
        }
        for (int i = 0; i < arguments.length; ++i) {
            Ensure.ensureArgumentNotNull(message, arguments[i]);
        }
    }
}

