/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.color.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.color.widgets.ColorChooserPanel;
import net.disy.commons.swing.color.widgets.ColorModel;
import net.disy.commons.swing.color.widgets.DefaultColorChooserConfiguration;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.layout.util.LayoutDirection;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.resources.DisyCommonsSwingMessages;
import net.disy.commons.swing.util.GuiUtilities;

public final class ColorChooserDialog {
    public static final Color showDialog(Component parent, DefaultColorChooserConfiguration configuration, Color color) {
        ColorModel colorModel = new ColorModel(color);
        final ColorChooserPanel colorChooserPanel = new ColorChooserPanel(colorModel, configuration.isTransparencyEnabled());
        final JDialog dialog = GuiUtilities.createDialog(parent, configuration.getColorChooserDialogTitle());
        dialog.setModal(true);
        final boolean[] canceled = new boolean[]{false};
        SmartAction okAction = new SmartAction(DisyCommonsSwingMessages.getString("ColorChooserDialog.Ok")){

            protected final void execute(Component parentComponent) {
                dialog.dispose();
                canceled[0] = false;
            }
        };
        SmartAction cancelAction = new SmartAction(DisyCommonsSwingMessages.getString("ColorChooserDialog.Cancel")){

            protected final void execute(Component parentComponent) {
                dialog.dispose();
                canceled[0] = true;
            }
        };
        SmartAction resetAction = new SmartAction(DisyCommonsSwingMessages.getString("ColorChooserDialog.Reset")){

            protected final void execute(Component parentComponent) {
                colorChooserPanel.resetColor();
            }
        };
        JButton okButton = new JButton(okAction);
        ButtonPanelBuilder builder = new ButtonPanelBuilder(LayoutDirection.HORIZONTAL);
        builder.add(okButton);
        builder.add(cancelAction);
        builder.add(resetAction);
        JPanel buttonPanel = builder.createPanel();
        dialog.getContentPane().setLayout(new BorderLayout(LayoutUtilities.getComponentGroupsSpacing(), LayoutUtilities.getComponentGroupsSpacing()));
        dialog.getContentPane().add((Component)colorChooserPanel.getContent(), "Center");
        dialog.getContentPane().add((Component)buttonPanel, "South");
        dialog.getRootPane().setDefaultButton(okButton);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        try {
            GuiUtilities.show(dialog);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (canceled[0]) {
            return color;
        }
        return colorModel.getColor();
    }
}

