/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.color.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.color.widgets.ColorModel;
import net.disy.commons.swing.color.widgets.ColorPreviewPanel;
import net.disy.commons.swing.color.widgets.TransparencyBarPanel;
import net.disy.commons.swing.layout.grid.GridDialogPanel;
import net.disy.commons.swing.layout.util.LayoutUtilities;

public final class ColorChooserPanel {
    private final Color initialColor;
    private final JPanel panel;
    private final ColorModel colorModel;

    public ColorChooserPanel(ColorModel colorModel, boolean hasTransparencyChangePanel) {
        Ensure.ensureArgumentNotNull(colorModel);
        this.initialColor = colorModel.getColor();
        this.colorModel = colorModel;
        JComponent mainContent = this.createMainContent();
        JPanel additionalControls = this.createAdditionalControls(hasTransparencyChangePanel);
        additionalControls.setBorder(new EmptyBorder(6, 5, 6, 5));
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(LayoutUtilities.getComponentGroupsSpacing(), LayoutUtilities.getComponentGroupsSpacing()));
        this.panel.add((Component)mainContent, "Center");
        this.panel.add((Component)additionalControls, "South");
    }

    private JPanel createAdditionalControls(boolean hasTransparencyChangePanel) {
        GridDialogPanel mainPanel = new GridDialogPanel();
        if (hasTransparencyChangePanel) {
            mainPanel.add(new TransparencyBarPanel(this.colorModel));
        }
        mainPanel.add(new ColorPreviewPanel(this.colorModel));
        JPanel additionalContent = mainPanel.getContent();
        return additionalContent;
    }

    private JComponent createMainContent() {
        final JColorChooser colorChooser = new JColorChooser();
        colorChooser.setColor(this.colorModel.getColor());
        colorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                Color plainColor = colorChooser.getColor();
                Color color = new Color(plainColor.getRed(), plainColor.getGreen(), plainColor.getBlue(), ColorChooserPanel.this.colorModel.getColor().getAlpha());
                ColorChooserPanel.this.colorModel.setColor(color);
            }
        });
        this.colorModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                colorChooser.setColor(ColorChooserPanel.this.colorModel.getColor());
            }
        });
        JTabbedPane tabPane = new JTabbedPane();
        AbstractColorChooserPanel[] oldPanels = colorChooser.getChooserPanels();
        GridBagConstraints constraints = new GridBagConstraints();
        new GridBagConstraints().gridwidth = 1;
        constraints.gridheight = 1;
        GridBagLayout layout = new GridBagLayout();
        for (int i = 0; i < oldPanels.length; ++i) {
            JPanel layoutPanel = new JPanel();
            layoutPanel.setLayout(layout);
            layout.setConstraints(oldPanels[i], constraints);
            layoutPanel.add(oldPanels[i]);
            tabPane.addTab(oldPanels[i].getDisplayName(), layoutPanel);
        }
        return tabPane;
    }

    public final JComponent getContent() {
        return this.panel;
    }

    public final void resetColor() {
        this.colorModel.setColor(this.initialColor);
    }
}

