/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.core;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Window;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.core.ISwingFrameOrDialog;

public final class SwingFrame
implements ISwingFrameOrDialog {
    private final JFrame frame;
    private boolean modal = false;

    public SwingFrame(JFrame frame) {
        Ensure.ensureArgumentNotNull(frame);
        this.frame = frame;
    }

    public final void setTitle(String title) {
        this.frame.setTitle(title);
    }

    public final JRootPane getRootPane() {
        return this.frame.getRootPane();
    }

    public final void pack() {
        this.frame.pack();
    }

    public final void setModal(boolean modal) {
        this.modal = modal;
    }

    public final Container getContentPane() {
        return this.frame.getContentPane();
    }

    public final void setDefaultCloseOperation(int closeOperation) {
        this.frame.setDefaultCloseOperation(closeOperation);
    }

    public final void addWindowListener(WindowListener windowListener) {
        this.frame.addWindowListener(windowListener);
    }

    public final void dispose() {
        this.setVisible(false);
        this.frame.dispose();
    }

    public final void validate() {
        this.frame.validate();
    }

    public final void repaint() {
        this.frame.repaint();
    }

    public final Window getWindow() {
        return this.frame;
    }

    public final void setResizable(boolean resizable) {
        this.frame.setResizable(resizable);
    }

    public final void show() {
        this.setVisible(true);
    }

    public final void setVisible(boolean visible) {
        this.frame.setVisible(visible);
        if (!this.modal) {
            return;
        }
        if (visible) {
            this.startModal();
            return;
        }
        this.stopModal();
    }

    private synchronized void startModal() {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                EventQueue theQueue = this.frame.getToolkit().getSystemEventQueue();
                while (this.isVisible()) {
                    AWTEvent event = theQueue.getNextEvent();
                    Object source = event.getSource();
                    if (event instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)event)).dispatch();
                        continue;
                    }
                    if (source instanceof Component) {
                        ((Component)source).dispatchEvent(event);
                        continue;
                    }
                    if (source instanceof MenuComponent) {
                        ((MenuComponent)source).dispatchEvent(event);
                        continue;
                    }
                    System.err.println("Unable to dispatch: " + event);
                }
            } else {
                while (this.isVisible()) {
                    this.wait();
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private synchronized void stopModal() {
        this.notifyAll();
    }

    public final boolean isVisible() {
        return this.frame.isVisible();
    }
}

