/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.message;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.disy.commons.core.message.Message;
import net.disy.commons.swing.dialog.foldout.FoldOutDialog;
import net.disy.commons.swing.dialog.foldout.IFoldOutPage;
import net.disy.commons.swing.dialog.message.FoldOutMessageDialogConfiguration;
import net.disy.commons.swing.dialog.message.MessageUserDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.UserDialog;

public final class MessageDialogFactory {
    private static final Font FIXEDWIDTH_FONT = new Font("Monospaced", 0, 11);

    public static final UserDialog createMessageDialog(Component parentComponent, final Message message) {
        UserDialog userDialog;
        if (message.getDetail() == null) {
            userDialog = new UserDialog(parentComponent, new MessageUserDialogConfiguration(message));
        } else {
            IFoldOutPage foldOutPage = new IFoldOutPage(){
                private JComponent content;

                public final void requestFocus() {
                }

                public final JComponent getContent() {
                    if (this.content == null) {
                        JTextArea textArea = new JTextArea(12, 70);
                        textArea.setFont(FIXEDWIDTH_FONT);
                        textArea.setText(message.getDetail());
                        this.content = new JScrollPane(textArea);
                    }
                    return this.content;
                }
            };
            userDialog = new FoldOutDialog(parentComponent, new FoldOutMessageDialogConfiguration(message, foldOutPage));
        }
        userDialog.getDialog().setResizable(false);
        return userDialog;
    }

    public static final void showMessageDialog(Component parent, Message message) {
        MessageDialogFactory.createMessageDialog(parent, message).show();
    }
}

