/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.wizard;

import javax.swing.JComponent;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.wizard.IWizardConfiguration;
import net.disy.commons.swing.dialog.wizard.IWizardPage;
import net.disy.commons.swing.events.CheckInputValidListener;
import net.disy.commons.swing.events.IInputValidCheckable;

public abstract class AbstractWizardPage
implements IWizardPage,
IInputValidCheckable {
    private CheckInputValidListener checkInputValidListener;
    private final IBasicMessage defaultMessage;
    private String title;
    private IBasicMessage message;
    private String description;
    private IWizardConfiguration wizard;
    private JComponent content;

    protected AbstractWizardPage(String description, IBasicMessage defaultMessage) {
        this(description, null, defaultMessage);
    }

    protected AbstractWizardPage(String description, String title, IBasicMessage defaultMessage) {
        Ensure.ensureArgumentNotNull("The default message page may not be null (" + this + ")", defaultMessage);
        this.defaultMessage = defaultMessage;
        this.setMessage(defaultMessage);
        this.description = description;
        this.title = title;
    }

    protected final IBasicMessage getDefaultMessage() {
        return this.defaultMessage;
    }

    protected final CheckInputValidListener getCheckInputValidListener() {
        if (this.checkInputValidListener == null) {
            this.checkInputValidListener = new CheckInputValidListener(this);
        }
        return this.checkInputValidListener;
    }

    public final void checkInputValid() {
        this.setMessage(this.createCurrentMessage());
    }

    protected abstract IBasicMessage createCurrentMessage();

    public final String getTitle() {
        if (this.title == null) {
            return this.getDescription();
        }
        return this.title;
    }

    public final void setWizard(IWizardConfiguration newWizard) {
        this.wizard = newWizard;
    }

    public final IWizardConfiguration getWizard() {
        return this.wizard;
    }

    private void updateMessage() {
        if (this.getWizard() == null || this.getWizard().getContainer() == null) {
            return;
        }
        this.getWizard().getContainer().updateMessage();
        this.getWizard().getContainer().updateButtons();
    }

    public final JComponent getContent() {
        if (this.content == null) {
            this.content = this.createContent();
        }
        return this.content;
    }

    protected abstract JComponent createContent();

    public final void setMessage(IBasicMessage message) {
        Ensure.ensureArgumentNotNull(message);
        this.message = message;
        this.updateMessage();
    }

    public final String getDescription() {
        return this.description;
    }

    public final IBasicMessage getMessage() {
        return this.message;
    }

    public final IWizardPage getNextPage() {
        return this.getWizard().getNextPage(this);
    }

    public final IWizardPage getPreviousPage() {
        return this.getWizard().getPreviousPage(this);
    }

    public boolean canFlipToNextPage() {
        return this.getNextPage() != null;
    }
}

