/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.filechooser.view;

import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public final class FileTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final FileSystemView fileSystemView;

    public FileTreeCellRenderer(FileSystemView fileSystemView) {
        this.fileSystemView = fileSystemView;
    }

    public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObject = node.getUserObject();
        if (userObject instanceof File) {
            File file = (File)userObject;
            this.setText(FileTreeCellRenderer.getText(this.fileSystemView, file));
            this.setIcon(FileTreeCellRenderer.getIcon(this.fileSystemView, file));
        } else {
            this.setIcon(null);
        }
        return this;
    }

    public static final Icon getIcon(FileSystemView fileSystemView2, File file) {
        return fileSystemView2.getSystemIcon(file);
    }

    public static final String getText(FileSystemView fileSystemView2, File file) {
        return fileSystemView2.getSystemDisplayName(file);
    }
}

