/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.filechooser.view;

import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import net.disy.commons.swing.filechooser.util.FileComparator;
import net.disy.commons.swing.filechooser.view.FolderSelectionPanel;

public final class FolderNode
extends DefaultMutableTreeNode {
    private final FolderSelectionPanel context;

    public FolderNode(FolderSelectionPanel context, File file) {
        super(file);
        context.registerNode(file, this);
        this.context = context;
    }

    public final File getFile() {
        return (File)this.getUserObject();
    }

    public final boolean getAllowsChildren() {
        return true;
    }

    public final int getChildCount() {
        this.asureChildrenLoaded();
        return super.getChildCount();
    }

    public final boolean isLeaf() {
        if (this.children != null) {
            return this.children.size() == 0;
        }
        if (this.context.getFileSystemView().isFloppyDrive(this.getFile())) {
            return false;
        }
        return this.getChildCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asureChildrenLoaded() {
        if (this.children != null) {
            return;
        }
        this.context.setBusy(true);
        try {
            this.children = new Vector();
            File[] childFiles = this.context.getFileSystemView().getFiles(this.getFile(), true);
            Arrays.sort(childFiles, new FileComparator(this.context.getFileSystemView()));
            for (int i = 0; i < childFiles.length; ++i) {
                if (!childFiles[i].isDirectory()) continue;
                FolderNode node = new FolderNode(this.context, childFiles[i]);
                this.children.add(node);
                node.setParent(this);
            }
            return;
        }
        finally {
            this.context.setBusy(false);
        }
    }
}

