/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.font;

import java.awt.Font;
import net.disy.commons.core.graphics.font.FontDescription;
import net.disy.commons.core.graphics.font.FontStyle;

public final class FontFactory {
    private static final FontStyle[] FONT_STYLE_MAPPING = new FontStyle[]{FontStyle.PLAIN, FontStyle.BOLD, FontStyle.ITALIC, FontStyle.BOLD_ITALIC};

    public static final FontStyle getStyleFromAwt(int awtStyle) {
        return FONT_STYLE_MAPPING[awtStyle];
    }

    public static final FontStyle getStyle(Font font) {
        return FontFactory.getStyleFromAwt(font.getStyle());
    }

    public static final int getAwtStyle(FontStyle fontStyle) {
        for (int awtStyle = 0; awtStyle < FONT_STYLE_MAPPING.length; ++awtStyle) {
            if (!FONT_STYLE_MAPPING[awtStyle].equals(fontStyle)) continue;
            return awtStyle;
        }
        throw new IllegalArgumentException("Unknown fontstyle " + fontStyle);
    }

    public static final Font createFont(String fontFamilyName, FontStyle style, int size) {
        return new Font(fontFamilyName, FontFactory.getAwtStyle(style), size);
    }

    public static final FontDescription createFontDescription(Font font) {
        return new FontDescription(font.getFamily(), FontFactory.getStyle(font), font.getSize());
    }
}

