/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view;

import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.view.DefaultFontDialogProperties;

public abstract class AbstractFontAdjustComponent {
    private JComponent content;
    private FontModel fontModel;
    private final DefaultFontDialogProperties properties;

    public AbstractFontAdjustComponent(FontModel fontModel, DefaultFontDialogProperties properties) {
        Ensure.ensureArgumentNotNull(properties);
        Ensure.ensureArgumentNotNull(fontModel);
        this.fontModel = fontModel;
        this.properties = properties;
        fontModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                if (AbstractFontAdjustComponent.this.content != null) {
                    AbstractFontAdjustComponent.this.updateFontModelView();
                }
            }
        });
    }

    protected final DefaultFontDialogProperties getFontDialogProperties() {
        return this.properties;
    }

    protected abstract void updateFontModelView();

    protected abstract JComponent createContent();

    public final JComponent getContent() {
        if (this.content == null) {
            this.content = this.createContent();
            this.updateFontModelView();
        }
        return this.content;
    }

    public final FontModel getFontModel() {
        return this.fontModel;
    }

    protected final void rejectUserInput() {
        Toolkit.getDefaultToolkit().beep();
        this.updateFontModelView();
    }
}

