/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.fontchooser.view;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.fontchooser.view.DefaultFontDialogProperties;
import net.disy.commons.swing.fontchooser.view.FontFamilyPanel;
import net.disy.commons.swing.fontchooser.view.FontSizePanel;
import net.disy.commons.swing.fontchooser.view.FontStylePanel;
import net.disy.commons.swing.fontchooser.view.accessory.FontPreviewPanel;
import net.disy.commons.swing.fontchooser.view.accessory.IFontChooserAccessory;
import net.disy.commons.swing.fontchooser.view.fixedwidth.FixedWidthFontFamilyNameFilter;
import net.disy.commons.swing.layout.grid.GridAlignment;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class FontChooserPanel {
    private final FontFamilyPanel fontFamilyPanel;
    private final FontStylePanel fontStylePanel;
    private final FontSizePanel fontSizePanel;
    private IFontChooserAccessory accessory;
    private final FontModel fontModel;
    private JComponent content;

    public FontChooserPanel(FontModel fontModel) {
        this(fontModel, new DefaultFontDialogProperties());
    }

    public FontChooserPanel(FontModel fontModel, DefaultFontDialogProperties properties) {
        Ensure.ensureArgumentNotNull(fontModel);
        Ensure.ensureArgumentNotNull(properties);
        this.fontModel = fontModel;
        this.fontFamilyPanel = new FontFamilyPanel(fontModel, properties);
        this.fontStylePanel = new FontStylePanel(fontModel, properties);
        this.fontSizePanel = new FontSizePanel(fontModel, properties);
        this.accessory = new FontPreviewPanel(fontModel, true);
    }

    public final FontModel getFontModel() {
        return this.fontModel;
    }

    private JComponent createContent() {
        JPanel panel = new JPanel(new GridDialogLayout(3, false));
        GridDialogLayoutData topData = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        topData.setVerticalAlignment(GridAlignment.FILL);
        panel.add((Component)this.fontFamilyPanel.getContent(), topData);
        panel.add((Component)this.fontStylePanel.getContent(), topData);
        panel.add((Component)this.fontSizePanel.getContent(), topData);
        GridDialogLayoutData bottomData = new GridDialogLayoutData(GridDialogLayoutData.FILL_BOTH);
        bottomData.setHorizontalSpan(3);
        panel.add((Component)this.accessory.getContent(), bottomData);
        return panel;
    }

    public final void setAccessory(IFontChooserAccessory accessory) {
        if (this.content != null) {
            throw new IllegalStateException("Exchanging the accessory after showing the panel is not allowed.");
        }
        accessory.setModel(this.fontModel);
        this.accessory = accessory;
    }

    public final JComponent getContent() {
        if (this.content == null) {
            this.content = this.createContent();
        }
        return this.content;
    }

    public final void setFontFamilyFilter(FixedWidthFontFamilyNameFilter filter) {
        this.fontFamilyPanel.setFontFamilyNameFilter(filter);
    }
}

