/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;
import net.disy.commons.swing.color.DisabledFilter;

public final class ColorFilterGraphics
extends Graphics2D {
    private final Graphics2D delegate;
    private final Component imageComponent;
    private final RGBImageFilter rgbFilter;

    public ColorFilterGraphics(Graphics2D delegate, Component imageComponent) {
        this(delegate, imageComponent, new DisabledFilter());
    }

    public ColorFilterGraphics(Graphics2D delegate, Component imageComponent, RGBImageFilter rgbFilter) {
        this.delegate = delegate;
        this.imageComponent = imageComponent;
        this.rgbFilter = rgbFilter;
    }

    private Image disabledImage(Image img) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(img.getSource(), this.rgbFilter);
        return this.imageComponent.createImage(filteredImageSource);
    }

    private Color disabledColor(Color color) {
        return new Color(this.rgbFilter.filterRGB(0, 0, color.getRGB()));
    }

    public final void addRenderingHints(Map hints) {
        this.delegate.addRenderingHints(hints);
    }

    public final void clearRect(int x, int y, int width, int height) {
        this.delegate.clearRect(x, y, width, height);
    }

    public final void clip(Shape s) {
        this.delegate.clip(s);
    }

    public final void clipRect(int x, int y, int width, int height) {
        this.delegate.clipRect(x, y, width, height);
    }

    public final void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.delegate.copyArea(x, y, width, height, dx, dy);
    }

    public final Graphics create() {
        return this.delegate.create();
    }

    public final Graphics create(int x, int y, int width, int height) {
        return this.delegate.create(x, y, width, height);
    }

    public final void dispose() {
        this.delegate.dispose();
    }

    public final void draw(Shape s) {
        this.delegate.draw(s);
    }

    public final void draw3DRect(int x, int y, int width, int height, boolean raised) {
        this.delegate.draw3DRect(x, y, width, height, raised);
    }

    public final void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.delegate.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public final void drawBytes(byte[] data, int offset, int length, int x, int y) {
        this.delegate.drawBytes(data, offset, length, x, y);
    }

    public final void drawChars(char[] data, int offset, int length, int x, int y) {
        this.delegate.drawChars(data, offset, length, x, y);
    }

    public final void drawGlyphVector(GlyphVector g, float x, float y) {
        this.delegate.drawGlyphVector(g, x, y);
    }

    public final boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return this.delegate.drawImage(this.disabledImage(img), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.disabledColor(bgcolor), observer);
    }

    public final boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.delegate.drawImage(this.disabledImage(img), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public final boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return this.delegate.drawImage(this.disabledImage(img), x, y, width, height, this.disabledColor(bgcolor), observer);
    }

    public final boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.delegate.drawImage(this.disabledImage(img), x, y, width, height, observer);
    }

    public final boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.delegate.drawImage(this.disabledImage(img), x, y, this.disabledColor(bgcolor), observer);
    }

    public final boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.delegate.drawImage(this.disabledImage(img), x, y, observer);
    }

    public final boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.delegate.drawImage(this.disabledImage(img), xform, obs);
    }

    public final void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public final void drawLine(int x1, int y1, int x2, int y2) {
        this.delegate.drawLine(x1, y1, x2, y2);
    }

    public final void drawOval(int x, int y, int width, int height) {
        this.delegate.drawOval(x, y, width, height);
    }

    public final void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.delegate.drawPolygon(xPoints, yPoints, nPoints);
    }

    public final void drawPolygon(Polygon p) {
        this.delegate.drawPolygon(p);
    }

    public final void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.delegate.drawPolyline(xPoints, yPoints, nPoints);
    }

    public final void drawRect(int x, int y, int width, int height) {
        this.delegate.drawRect(x, y, width, height);
    }

    public final void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.delegate.drawRenderableImage(img, xform);
    }

    public final void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        this.delegate.drawRenderedImage(img, xform);
    }

    public final void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.delegate.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public final void drawString(String s, float x, float y) {
        this.delegate.drawString(s, x, y);
    }

    public final void drawString(String str, int x, int y) {
        this.delegate.drawString(str, x, y);
    }

    public final void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.delegate.drawString(iterator, x, y);
    }

    public final void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.delegate.drawString(iterator, x, y);
    }

    public final boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public final void fill(Shape s) {
        this.delegate.fill(s);
    }

    public final void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.delegate.fill3DRect(x, y, width, height, raised);
    }

    public final void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.delegate.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public final void fillOval(int x, int y, int width, int height) {
        this.delegate.fillOval(x, y, width, height);
    }

    public final void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.delegate.fillPolygon(xPoints, yPoints, nPoints);
    }

    public final void fillPolygon(Polygon p) {
        this.delegate.fillPolygon(p);
    }

    public final void fillRect(int x, int y, int width, int height) {
        this.delegate.fillRect(x, y, width, height);
    }

    public final void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.delegate.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public final Color getBackground() {
        return this.delegate.getBackground();
    }

    public final Shape getClip() {
        return this.delegate.getClip();
    }

    public final Rectangle getClipBounds() {
        return this.delegate.getClipBounds();
    }

    public final Rectangle getClipBounds(Rectangle r) {
        return this.delegate.getClipBounds(r);
    }

    public final Rectangle getClipRect() {
        return this.delegate.getClipRect();
    }

    public final Color getColor() {
        return this.delegate.getColor();
    }

    public final Composite getComposite() {
        return this.delegate.getComposite();
    }

    public final GraphicsConfiguration getDeviceConfiguration() {
        return this.delegate.getDeviceConfiguration();
    }

    public final Font getFont() {
        return this.delegate.getFont();
    }

    public final FontMetrics getFontMetrics() {
        return this.delegate.getFontMetrics();
    }

    public final FontMetrics getFontMetrics(Font f) {
        return this.delegate.getFontMetrics(f);
    }

    public final FontRenderContext getFontRenderContext() {
        return this.delegate.getFontRenderContext();
    }

    public final Paint getPaint() {
        return this.delegate.getPaint();
    }

    public final Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.delegate.getRenderingHint(hintKey);
    }

    public final RenderingHints getRenderingHints() {
        return this.delegate.getRenderingHints();
    }

    public final Stroke getStroke() {
        return this.delegate.getStroke();
    }

    public final AffineTransform getTransform() {
        return this.delegate.getTransform();
    }

    public final int hashCode() {
        return this.delegate.hashCode();
    }

    public final boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return this.delegate.hit(rect, s, onStroke);
    }

    public final boolean hitClip(int x, int y, int width, int height) {
        return this.delegate.hitClip(x, y, width, height);
    }

    public final void rotate(double theta) {
        this.delegate.rotate(theta);
    }

    public final void rotate(double theta, double x, double y) {
        this.delegate.rotate(theta, x, y);
    }

    public final void scale(double sx, double sy) {
        this.delegate.scale(sx, sy);
    }

    public final void setBackground(Color color) {
        this.delegate.setBackground(this.disabledColor(color));
    }

    public final void setClip(int x, int y, int width, int height) {
        this.delegate.setClip(x, y, width, height);
    }

    public final void setClip(Shape clip) {
        this.delegate.setClip(clip);
    }

    public final void setColor(Color color) {
        this.delegate.setColor(this.disabledColor(color));
    }

    public final void setComposite(Composite comp) {
        this.delegate.setComposite(comp);
    }

    public final void setFont(Font font) {
        this.delegate.setFont(font);
    }

    public final void setPaint(Paint paint) {
        this.delegate.setPaint(paint);
    }

    public final void setPaintMode() {
        this.delegate.setPaintMode();
    }

    public final void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.delegate.setRenderingHint(hintKey, hintValue);
    }

    public final void setRenderingHints(Map hints) {
        this.delegate.setRenderingHints(hints);
    }

    public final void setStroke(Stroke s) {
        this.delegate.setStroke(s);
    }

    public final void setTransform(AffineTransform Tx) {
        this.delegate.setTransform(Tx);
    }

    public final void setXORMode(Color c1) {
        this.delegate.setXORMode(c1);
    }

    public final void shear(double shx, double shy) {
        this.delegate.shear(shx, shy);
    }

    public final String toString() {
        return this.delegate.toString();
    }

    public final void transform(AffineTransform Tx) {
        this.delegate.transform(Tx);
    }

    public final void translate(double tx, double ty) {
        this.delegate.translate(tx, ty);
    }

    public final void translate(int x, int y) {
        this.delegate.translate(x, y);
    }
}

