/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.layout.grid;

import java.awt.Component;
import java.awt.Dimension;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class GridCell {
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    private final int columnIndex;
    private final int rowIndex;
    private final GridDialogLayoutData layoutData;
    private final Component component;
    private final Dimension preferredSize;
    private final Dimension preferredComponentSize;
    private final Dimension minimumSize;

    public GridCell(Component component, GridDialogLayoutData layoutData, int columnIndex, int rowIndex) {
        this.component = component;
        this.layoutData = layoutData;
        this.columnIndex = columnIndex;
        this.rowIndex = rowIndex;
        this.preferredComponentSize = component.getPreferredSize();
        this.minimumSize = this.computeMinimumSize();
        this.preferredSize = this.computePreferredSize();
    }

    private Dimension computeMinimumSize() {
        Dimension minimumComponentSize = this.component.getMinimumSize();
        int width = minimumComponentSize.width + this.layoutData.getHorizontalIndent();
        if (this.layoutData.getWidthHint() > width) {
            width = this.layoutData.getWidthHint();
        }
        int height = minimumComponentSize.height;
        if (this.layoutData.getHeightHint() > height) {
            height = this.layoutData.getHeightHint();
        }
        return new Dimension(width, height);
    }

    private Dimension computePreferredSize() {
        int width = this.preferredComponentSize.width + this.layoutData.getHorizontalIndent();
        if (this.layoutData.getWidthHint() > width) {
            width = this.layoutData.getWidthHint();
        }
        int height = this.preferredComponentSize.height;
        if (this.layoutData.getHeightHint() > height) {
            height = this.layoutData.getHeightHint();
        }
        return new Dimension(width, height);
    }

    public final GridDialogLayoutData getLayoutData() {
        return this.layoutData;
    }

    public final int getRowIndex() {
        return this.rowIndex;
    }

    public final int getRowSpan() {
        return this.layoutData.getVerticalSpan();
    }

    public final int getColumnIndex() {
        return this.columnIndex;
    }

    public final int getColumnSpan() {
        return this.layoutData.getHorizontalSpan();
    }

    public final Dimension getMinimumSize() {
        if (this.component.isVisible()) {
            return this.minimumSize;
        }
        return EMPTY_DIMENSION;
    }

    public final Dimension getPreferredSize() {
        if (this.component.isVisible()) {
            return this.preferredSize;
        }
        return EMPTY_DIMENSION;
    }

    public final Dimension getPreferredComponentSize() {
        if (this.component.isVisible()) {
            return this.preferredComponentSize;
        }
        return EMPTY_DIMENSION;
    }

    public final Component getComponent() {
        return this.component;
    }
}

