/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.mousecursor;

import java.awt.Cursor;
import java.util.HashMap;
import java.util.Map;
import net.disy.commons.swing.mousecursor.CursorCapabilities;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorInitializer;
import net.disy.commons.swing.mousecursor.ExtendedCursor;

public final class CursorProvider {
    private CursorCapabilities cursorCapabilities;
    private static CursorProvider instance = new CursorProvider();
    private final Map cursorDescriptions = new HashMap();

    private CursorProvider() {
    }

    public static final CursorProvider getInstance() {
        return instance;
    }

    public final void addCursorDescriptionSet(ExtendedCursor set) {
        if (this.cursorDescriptions.containsKey(set.getCursorId())) {
            throw new IllegalArgumentException("Cursor for id " + set.getCursorId() + " already registered");
        }
        this.cursorDescriptions.put(set.getCursorId(), set);
    }

    public final Cursor getCursor(CursorId cursorId) {
        ExtendedCursor set = this.getExtendedCursor(cursorId);
        if (set == null) {
            return Cursor.getDefaultCursor();
        }
        return set.getCursor();
    }

    public final ExtendedCursor getExtendedCursor(CursorId cursorId) {
        ExtendedCursor extendedCursor = (ExtendedCursor)this.cursorDescriptions.get(cursorId);
        if (extendedCursor == null) {
            return null;
        }
        if (!extendedCursor.isInitialized()) {
            extendedCursor.initialize(this.getCursorCapabilities());
        }
        return extendedCursor;
    }

    private CursorCapabilities getCursorCapabilities() {
        if (this.cursorCapabilities == null) {
            this.cursorCapabilities = CursorCapabilities.getSystemCapabilities();
        }
        return this.cursorCapabilities;
    }

    static {
        new CursorInitializer().initCursorDescriptions(CursorProvider.getInstance());
    }
}

