/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.toolbar;

import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import net.disy.commons.swing.action.IToggleAction;
import net.disy.commons.swing.button.ToggleActionButton;

public final class ToolBarUtilities {
    private static final Insets TOOLBAR_BUTTON_MARGIN;

    public static final AbstractButton createToolBarButton(Action action) {
        AbstractButton button = action instanceof IToggleAction ? new ToggleActionButton() : new JButton();
        button.setAction(action);
        ToolBarUtilities.configureToolBarButton(button);
        return button;
    }

    public static final void configureToolBarButton(AbstractButton button) {
        button.setFocusPainted(false);
        button.setMargin(TOOLBAR_BUTTON_MARGIN);
        if (button.getToolTipText() == null) {
            button.setToolTipText(button.getText());
        }
        if (button.getIcon() != null) {
            button.setText(null);
        }
    }

    static {
        new Insets(1, 1, 1, 1);
        TOOLBAR_BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    }
}

