/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToggleButton;
import net.disy.commons.core.util.Ensure;

public final class ToggleComponentEnabler {
    private JToggleButton button;
    private Component[] components;

    public static final void connect(JToggleButton button, Component component) {
        ToggleComponentEnabler.connect(button, new Component[]{component});
    }

    public static final void connect(JToggleButton button, Component[] components) {
        ToggleComponentEnabler.connect(button, components, new Component[0]);
    }

    public static final void connect(JToggleButton button, Component[] components, Component[] decorations) {
        new ToggleComponentEnabler(button, components, decorations);
    }

    private ToggleComponentEnabler(JToggleButton button, Component[] components, Component[] decorations) {
        Ensure.ensureNotNull(button);
        Ensure.ensureNotNull(components);
        this.button = button;
        this.components = components;
        this.setButtonListeners();
        this.listenToComponentClicks(components);
        this.updateComponentsEnabled();
        this.addDecorationListeners(decorations);
    }

    private void addDecorationListeners(Component[] decorations) {
        for (int i = 0; i < decorations.length; ++i) {
            Component currentDecoration = decorations[i];
            currentDecoration.addMouseListener(new MouseAdapter(){

                public final void mousePressed(MouseEvent e) {
                    ToggleComponentEnabler.this.button.doClick();
                }
            });
            this.addEnabledListener(currentDecoration);
        }
    }

    private void addEnabledListener(final Component component) {
        this.button.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(ToggleComponentEnabler.this.button.isEnabled());
            }
        });
        component.setEnabled(this.button.isEnabled());
    }

    private void listenToComponentClicks(Component[] componentsToListenTo) {
        for (int i = 0; i < componentsToListenTo.length; ++i) {
            Component component = componentsToListenTo[i];
            component.addMouseListener(new MouseAdapter(){

                public final void mousePressed(MouseEvent e) {
                    if (ToggleComponentEnabler.this.button.isEnabled() && !ToggleComponentEnabler.this.button.isSelected()) {
                        ToggleComponentEnabler.this.button.doClick();
                        if (e.getSource() instanceof Component) {
                            ((Component)e.getSource()).requestFocus();
                        }
                    }
                }
            });
            if (!(component instanceof Container)) continue;
            this.listenToComponentClicks(((Container)component).getComponents());
        }
    }

    private void setButtonListeners() {
        this.button.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                ToggleComponentEnabler.this.updateComponentsEnabled();
            }
        });
        this.button.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            public final void propertyChange(PropertyChangeEvent evt) {
                ToggleComponentEnabler.this.updateComponentsEnabled();
            }
        });
    }

    private void setComponentsEnabled(boolean enabled) {
        this.setComponentsEnabled(this.components, enabled);
    }

    private void setComponentsEnabled(Component[] components, boolean enabled) {
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            component.setEnabled(enabled);
            if (!(component instanceof Container)) continue;
            this.setComponentsEnabled(((Container)component).getComponents(), enabled);
        }
    }

    private void updateComponentsEnabled() {
        this.setComponentsEnabled(this.button.isSelected() && this.button.isEnabled());
    }
}

