/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.core.geometry;

import java.awt.Point;
import java.awt.Rectangle;
import net.disy.commons.core.util.Ensure;

public final class SmartRectangle
extends Rectangle {
    public SmartRectangle(Rectangle rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public SmartRectangle(int ulx, int uly, int width, int height) {
        super(ulx, uly, width, height);
        Ensure.ensureArgumentTrue("Width <0 : '" + width + "'", width >= 0);
        Ensure.ensureArgumentTrue("Height <0 : '" + height + "'", height >= 0);
    }

    public final int getUlx() {
        return this.x;
    }

    public final int getUly() {
        return this.y;
    }

    public final int getLrx() {
        return this.x + this.width;
    }

    public final int getLry() {
        return this.y + this.height;
    }

    public final void setLocation(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public final boolean contains(Rectangle r) {
        return this.x <= r.x && this.y <= r.y && this.x + this.width >= r.x + r.width && this.y + this.height >= r.y + r.height;
    }

    public final Point getCenter() {
        return new Point((this.getLrx() + this.getUlx()) / 2, (this.getLry() + this.getUly()) / 2);
    }
}

