/*
 * Decompiled with CFR 0.152.
 */
package net.disy.commons.swing.dialog.message;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.userdialog.AbstractDialogPage;
import net.disy.commons.swing.layout.grid.GridAlignment;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.message.MessageTypeUi;
import net.disy.commons.swing.widgets.AutoWrappingLabel;

public final class MessageDialogPage
extends AbstractDialogPage {
    private Message message;

    public MessageDialogPage(Message message) {
        super(new BasicMessage());
        Ensure.ensureArgumentNotNull(message);
        this.message = message;
    }

    public final JComponent createContent() {
        GridDialogLayoutData iconData = new GridDialogLayoutData();
        iconData.setGrabExcessVerticalSpace(true);
        iconData.setVerticalAlignment(GridAlignment.FILL);
        GridDialogLayoutData textData = new GridDialogLayoutData();
        textData.setGrabExcessHorizontalSpace(true);
        textData.setHorizontalAlignment(GridAlignment.FILL);
        Icon icon = MessageTypeUi.getIcon(this.message.getType());
        AutoWrappingLabel label = new AutoWrappingLabel(this.message.getText(), 294);
        JPanel panel = new JPanel(new GridDialogLayout(2, false, 13, 0));
        label.setBackground(panel.getBackground());
        panel.add((Component)new JLabel(icon), iconData);
        panel.add((Component)label.getContent(), textData);
        return panel;
    }

    public final IBasicMessage createCurrentMessage() {
        return this.getDefaultMessage();
    }

    public final String getDescription() {
        return null;
    }

    public final String getTitle() {
        if (this.message.getTitle() == null) {
            return MessageTypeUi.getLabel(this.message.getType());
        }
        return this.message.getTitle();
    }
}

