/*
 * Decompiled with CFR 0.152.
 */
package javolution.context;

import javolution.Javolution;
import javolution.context.Context;
import javolution.context.ObjectFactory;
import javolution.lang.Configurable;
import javolution.util.StandardLog;

public abstract class LogContext
extends Context {
    private static volatile LogContext _Default = new StandardLog();
    public static final Class<? extends LogContext> STANDARD = _Default.getClass();
    public static final Class<? extends LogContext> NULL = new NullLog().getClass();
    public static final Class<? extends LogContext> SYSTEM_OUT = new SystemOut().getClass();
    public static final Class<? extends LogContext> CONSOLE = new ConsoleLog().getClass();
    public static final Configurable<Class<? extends LogContext>> DEFAULT = new Configurable(STANDARD){

        protected void notifyChange() {
            _Default = (LogContext)ObjectFactory.getInstance((Class)this.get()).object();
        }
    };

    protected LogContext() {
    }

    public static LogContext getCurrent() {
        for (Context context = Context.getCurrent(); context != null; context = context.getOuter()) {
            if (!(context instanceof LogContext)) continue;
            return (LogContext)context;
        }
        return _Default;
    }

    public static LogContext getDefault() {
        return _Default;
    }

    public static void info(CharSequence charSequence) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logInfo(charSequence);
    }

    public static void info(String string) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logInfo(string);
    }

    public static void warning(CharSequence charSequence) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logWarning(charSequence);
    }

    public static void warning(String string) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logWarning(string);
    }

    public static void error(Throwable throwable) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logError(throwable, (CharSequence)null);
    }

    public static void error(Throwable throwable, CharSequence charSequence) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logError(throwable, charSequence);
    }

    public static void error(Throwable throwable, String string) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logError(throwable, string);
    }

    public static void error(CharSequence charSequence) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logError(null, charSequence);
    }

    public static final void error(String string) {
        LogContext logContext = LogContext.getCurrent();
        logContext.logError(null, string);
    }

    public abstract boolean isInfoLogged();

    public abstract void logInfo(CharSequence var1);

    public final void logInfo(String string) {
        this.logInfo(Javolution.j2meToCharSeq(string));
    }

    public abstract boolean isWarningLogged();

    public abstract void logWarning(CharSequence var1);

    public final void logWarning(String string) {
        this.logWarning(Javolution.j2meToCharSeq(string));
    }

    public abstract boolean isErrorLogged();

    public abstract void logError(Throwable var1, CharSequence var2);

    public final void logError(Throwable throwable, String string) {
        this.logError(throwable, Javolution.j2meToCharSeq(string));
    }

    protected void enterAction() {
    }

    protected void exitAction() {
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new ConsoleLog();
            }
        }, CONSOLE);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new NullLog();
            }
        }, NULL);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new SystemOut();
            }
        }, SYSTEM_OUT);
    }

    private static class ConsoleLog
    extends SystemOut {
        private ConsoleLog() {
        }
    }

    private static final class NullLog
    extends SystemOut {
        private NullLog() {
        }

        public boolean isInfoLogged() {
            return false;
        }

        public void logInfo(CharSequence charSequence) {
        }

        public boolean isWarningLogged() {
            return false;
        }

        public void logWarning(CharSequence charSequence) {
        }

        public boolean isErrorLogged() {
            return false;
        }

        public void logError(Throwable throwable, CharSequence charSequence) {
        }
    }

    private static class SystemOut
    extends LogContext {
        private SystemOut() {
        }

        public boolean isInfoLogged() {
            return true;
        }

        public void logInfo(CharSequence charSequence) {
            System.out.print("[info] ");
            System.out.println(charSequence);
        }

        public boolean isWarningLogged() {
            return true;
        }

        public void logWarning(CharSequence charSequence) {
            System.out.print("[warning] ");
            System.out.println(charSequence);
        }

        public boolean isErrorLogged() {
            return true;
        }

        public void logError(Throwable throwable, CharSequence charSequence) {
            System.out.print("[error] ");
            if (throwable != null) {
                System.out.print(throwable.getClass().getName());
                System.out.print(" - ");
            }
            String string = charSequence != null ? ((Object)charSequence).toString() : (throwable != null ? throwable.getMessage() : "");
            System.out.println(string);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        }
    }
}

