/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.Javolution;
import javolution.context.LogContext;

public class StandardLog
extends LogContext {
    private Logger _logger;

    public StandardLog() {
        this(Logger.getLogger(""));
    }

    public StandardLog(Logger logger) {
        this._logger = logger;
    }

    public final Logger getLogger() {
        return this._logger;
    }

    public static boolean isLoggable(Level level) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            return ((StandardLog)logContext)._logger.isLoggable(level);
        }
        if (level.intValue() >= Level.WARNING.intValue()) {
            return logContext.isWarningLogged();
        }
        if (level.intValue() >= Level.INFO.intValue()) {
            return logContext.isInfoLogged();
        }
        return false;
    }

    public static void log(LogRecord logRecord) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.log(logRecord);
        } else {
            Throwable throwable = logRecord.getThrown();
            if (throwable != null) {
                if (logContext.isErrorLogged()) {
                    logContext.logError(throwable, Javolution.j2meToCharSeq(logRecord.getMessage()));
                }
            } else if (logRecord.getLevel().intValue() > Level.WARNING.intValue()) {
                if (logContext.isWarningLogged()) {
                    logContext.logWarning(Javolution.j2meToCharSeq(logRecord.getMessage()));
                }
            } else if (logRecord.getLevel().intValue() > Level.INFO.intValue() && logContext.isInfoLogged()) {
                logContext.logInfo(Javolution.j2meToCharSeq(logRecord.getMessage()));
            }
        }
    }

    public static void severe(String string) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.severe(string);
        } else if (logContext.isWarningLogged()) {
            logContext.logWarning(Javolution.j2meToCharSeq(string));
        }
    }

    public static void config(String string) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.config(string);
        }
    }

    public static void fine(String string) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.fine(string);
        }
    }

    public static void finer(String string) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.finer(string);
        }
    }

    public static void finest(String string) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.finest(string);
        }
    }

    public static void throwing(String string, String string2, Throwable throwable) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.throwing(string, string2, throwable);
        } else if (logContext.isErrorLogged()) {
            logContext.logError(throwable, (CharSequence)null);
        }
    }

    public static void entering(String string, String string2) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.entering(string, string2);
        }
    }

    public static void exiting(String string, String string2) {
        LogContext logContext = LogContext.getCurrent();
        if (logContext instanceof StandardLog) {
            ((StandardLog)logContext)._logger.exiting(string, string2);
        }
    }

    public boolean isInfoLogged() {
        return this._logger.isLoggable(Level.INFO);
    }

    public boolean isWarningLogged() {
        return this._logger.isLoggable(Level.WARNING);
    }

    public boolean isErrorLogged() {
        return this._logger.isLoggable(Level.SEVERE);
    }

    public void logInfo(CharSequence charSequence) {
        this._logger.info(((Object)charSequence).toString());
    }

    public void logWarning(CharSequence charSequence) {
        this._logger.warning(((Object)charSequence).toString());
    }

    public void logError(Throwable throwable, CharSequence charSequence) {
        String string;
        String string2 = string = charSequence != null ? ((Object)charSequence).toString() : "";
        if (throwable != null) {
            this._logger.log(Level.SEVERE, string, throwable);
        } else {
            this._logger.log(Level.SEVERE, string);
        }
    }
}

