package org.jaxup.dom4j;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.jaxen.Navigator;

/**
 * Only filtering out namespace nodes is supported yet.
 */
public class TypeFilteredIterator implements Iterator
{
    public final static int TYPE_NAMESPACE = 1;

    private Iterator original;
    private Navigator navigator;
    private int type;
    private Object peekNext;

    public TypeFilteredIterator(Navigator navigator, Iterator original, int type)
    {
        if (original == null)
        {
            throw new NullPointerException("original");
        }
        this.navigator = navigator;
        this.original = original;
        this.type = type;
    }

    public boolean hasNext()
    {
        if (peekNext != null)
        {
            return true;
        }

        loop : while (original.hasNext())
        {
            Object next = original.next();
            switch (type)
            {
                case TYPE_NAMESPACE :
                    if (navigator.isNamespace(next))
                    {
                        continue loop;
                    }
                    break;
            }
            peekNext = next;
            return true;
        }

        return false;
    }

    public Object next()
    {
        if (peekNext != null)
        {
            Object result = peekNext;
            peekNext = null;
            return result;
        }

        loop : while (original.hasNext())
        {
            Object next = original.next();
            switch (type)
            {
                case TYPE_NAMESPACE :
                    if (navigator.isNamespace(next))
                    {
                        continue loop;
                    }
                    break;
            }
            return next;
        }

        throw new NoSuchElementException("next");
    }

    public void remove()
    {
        throw new UnsupportedOperationException("remove");
    }
}
