/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Inet6Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class AAAARecord
extends Record {
    private static AAAARecord member = new AAAARecord();
    private Inet6Address address;

    private AAAARecord() {
    }

    private AAAARecord(Name name, int dclass, long ttl) {
        super(name, 28, dclass, ttl);
    }

    static AAAARecord getMember() {
        return member;
    }

    public AAAARecord(Name name, int dclass, long ttl, Inet6Address address) {
        this(name, dclass, ttl);
        this.address = address;
    }

    Record rrFromWire(Name name, int type, int dclass, long ttl, int length, DataByteInputStream in) throws IOException {
        AAAARecord rec = new AAAARecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        byte[] data = new byte[16];
        in.read(data);
        rec.address = new Inet6Address(data);
        return rec;
    }

    Record rdataFromString(Name name, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        AAAARecord rec = new AAAARecord(name, dclass, ttl);
        try {
            rec.address = new Inet6Address(st.getString());
        }
        catch (TextParseException e) {
            throw st.exception(e.getMessage());
        }
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.address != null) {
            sb.append(this.address);
        }
        return sb.toString();
    }

    public Inet6Address getAddress() {
        return this.address;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.address == null) {
            return;
        }
        byte[] b = this.address.toBytes();
        out.writeArray(b);
    }
}

