/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;

public final class Address {
    private Address() {
    }

    public static int[] toArray(String s) {
        int[] values = new int[4];
        int length = s.length();
        int currentOctet = 0;
        int numDigits = 0;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if (numDigits == 3) {
                    return null;
                }
                if (numDigits > 0 && values[currentOctet] == 0) {
                    return null;
                }
                ++numDigits;
                int n = currentOctet;
                values[n] = values[n] * 10;
                int n2 = currentOctet;
                values[n2] = values[n2] + (c - 48);
                if (values[currentOctet] > 255) {
                    return null;
                }
            } else if (c == '.') {
                if (currentOctet == 3) {
                    return null;
                }
                if (numDigits == 0) {
                    return null;
                }
                ++currentOctet;
                numDigits = 0;
            } else {
                return null;
            }
            ++i;
        }
        if (currentOctet != 3) {
            return null;
        }
        if (numDigits == 0) {
            return null;
        }
        return values;
    }

    public static boolean isDottedQuad(String s) {
        int[] address = Address.toArray(s);
        return address != null;
    }

    public static String toDottedQuad(byte[] addr) {
        return (addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF);
    }

    private static Record[] lookupHostName(String name) throws UnknownHostException {
        try {
            Record[] records = new Lookup(name).run();
            if (records == null) {
                throw new UnknownHostException("unknown host");
            }
            return records;
        }
        catch (TextParseException e) {
            throw new UnknownHostException("invalid name");
        }
    }

    public static InetAddress getByName(String name) throws UnknownHostException {
        if (Address.isDottedQuad(name)) {
            return InetAddress.getByName(name);
        }
        Record[] records = Address.lookupHostName(name);
        ARecord a = (ARecord)records[0];
        return a.getAddress();
    }

    public static InetAddress[] getAllByName(String name) throws UnknownHostException {
        if (Address.isDottedQuad(name)) {
            return InetAddress.getAllByName(name);
        }
        Record[] records = Address.lookupHostName(name);
        InetAddress[] addrs = new InetAddress[records.length];
        int i = 0;
        while (i < records.length) {
            ARecord a = (ARecord)records[i];
            addrs[i] = a.getAddress();
            ++i;
        }
        return addrs;
    }

    public static String getHostName(InetAddress addr) throws UnknownHostException {
        Name name = ReverseMap.fromAddress(addr);
        Record[] records = new Lookup(name, 12).run();
        if (records == null) {
            throw new UnknownHostException("unknown address");
        }
        PTRRecord ptr = (PTRRecord)records[0];
        return ptr.getTarget().toString();
    }
}

