/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base64;

public class CERTRecord
extends Record {
    public static final int PKIX = 1;
    public static final int SPKI = 2;
    public static final int PGP = 3;
    public static final int URL = 253;
    public static final int OID = 254;
    private static CERTRecord member = new CERTRecord();
    private int certType;
    private int keyTag;
    private int alg;
    private byte[] cert;

    private CERTRecord() {
    }

    private CERTRecord(Name name, int dclass, long ttl) {
        super(name, 37, dclass, ttl);
    }

    static CERTRecord getMember() {
        return member;
    }

    public CERTRecord(Name name, int dclass, long ttl, int certType, int keyTag, int alg, byte[] cert) {
        this(name, dclass, ttl);
        Record.checkU16("certType", certType);
        Record.checkU16("keyTag", keyTag);
        Record.checkU8("alg", alg);
        this.certType = certType;
        this.keyTag = keyTag;
        this.alg = alg;
        this.cert = cert;
    }

    Record rrFromWire(Name name, int type, int dclass, long ttl, int length, DataByteInputStream in) throws IOException {
        CERTRecord rec = new CERTRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.certType = in.readShort();
        rec.keyTag = in.readUnsignedShort();
        rec.alg = in.readByte();
        if (length > 5) {
            rec.cert = new byte[length - 5];
            in.read(rec.cert);
        }
        return rec;
    }

    Record rdataFromString(Name name, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        CERTRecord rec = new CERTRecord(name, dclass, ttl);
        rec.certType = st.getUInt16();
        rec.keyTag = st.getUInt16();
        rec.alg = st.getUInt8();
        rec.cert = base64.fromString(Record.remainingStrings(st));
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.cert != null) {
            sb.append(this.certType);
            sb.append(" ");
            sb.append(this.keyTag);
            sb.append(" ");
            sb.append(this.alg);
            if (this.cert != null) {
                if (Options.check("multiline")) {
                    sb.append(" (\n");
                    sb.append(base64.formatString(this.cert, 64, "\t", true));
                } else {
                    sb.append(" ");
                    sb.append(base64.toString(this.cert));
                }
            }
        }
        return sb.toString();
    }

    public int getCertType() {
        return this.certType;
    }

    public int getKeyTag() {
        return this.keyTag;
    }

    public int getAlgorithm() {
        return this.alg;
    }

    public byte[] getCert() {
        return this.cert;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.cert == null) {
            return;
        }
        out.writeShort(this.certType);
        out.writeShort(this.keyTag);
        out.writeByte(this.alg);
        out.writeArray(this.cert);
    }
}

