/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public abstract class MX_KXRecord
extends Record {
    protected int priority;
    protected Name target;

    protected MX_KXRecord() {
    }

    protected MX_KXRecord(Name name, int type, int dclass, long ttl) {
        super(name, type, dclass, ttl);
    }

    public MX_KXRecord(Name name, int type, int dclass, long ttl, int priority, Name target) {
        super(name, type, dclass, ttl);
        Record.checkU16("priority", priority);
        this.priority = priority;
        if (!target.isAbsolute()) {
            throw new RelativeNameException(target);
        }
        this.target = target;
    }

    protected static Record rrFromWire(MX_KXRecord rec, DataByteInputStream in) throws IOException {
        if (in == null) {
            return rec;
        }
        rec.priority = in.readUnsignedShort();
        rec.target = new Name(in);
        return rec;
    }

    protected static Record rdataFromString(MX_KXRecord rec, Tokenizer st, Name origin) throws IOException {
        rec.priority = st.getUInt16();
        rec.target = st.getName(origin);
        return rec;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.target != null) {
            sb.append(this.priority);
            sb.append(" ");
            sb.append(this.target);
        }
        return sb.toString();
    }

    public Name getTarget() {
        return this.target;
    }

    public int getPriority() {
        return this.priority;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.target == null) {
            return;
        }
        out.writeShort(this.priority);
        if (this.type == 15) {
            this.target.toWire(out, c, canonical);
        } else {
            this.target.toWire(out, null, canonical);
        }
    }

    public Name getAdditionalName() {
        return this.target;
    }
}

