/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TTL;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;

public class Master {
    private Name origin;
    private File file;
    private Record last = null;
    private long defaultTTL = -1L;
    private Master included = null;
    private Tokenizer st;

    Master(File file, Name defaultOrigin) throws IOException {
        this.file = file;
        this.st = new Tokenizer(file);
        this.origin = defaultOrigin;
    }

    public Master(String filename, Name origin) throws IOException {
        this(new File(filename), origin);
    }

    public Master(String filename) throws IOException {
        this(new File(filename), null);
    }

    public Master(InputStream in, Name defaultOrigin) {
        this.st = new Tokenizer(in);
        this.origin = defaultOrigin;
    }

    public Master(InputStream in) {
        this(in, null);
    }

    private Name parseName(String s, Name origin) throws TextParseException {
        try {
            return Name.fromString(s, origin);
        }
        catch (TextParseException e) {
            throw this.st.exception(e.getMessage());
        }
    }

    public Record nextRecord() throws IOException {
        long ttl;
        String s;
        Name name;
        block16: {
            Tokenizer.Token token;
            if (this.included != null) {
                Record rec = this.included.nextRecord();
                if (rec != null) {
                    return rec;
                }
                this.included = null;
            }
            while (true) {
                token = this.st.get(true, false);
                if (token.type == 2) {
                    if (this.last == null) {
                        throw this.st.exception("no owner");
                    }
                    name = this.last.getName();
                    break block16;
                }
                if (token.type == 1) continue;
                if (token.type == 0) {
                    return null;
                }
                s = token.value;
                if (s.equals("$ORIGIN")) {
                    this.origin = this.st.getName(Name.root);
                    this.st.getEOL();
                    continue;
                }
                if (!s.equals("$TTL")) break;
                this.defaultTTL = this.st.getTTL();
                this.st.getEOL();
            }
            if (s.equals("$INCLUDE")) {
                String filename = this.st.getString();
                String parent = this.file.getParent();
                File newfile = new File(this.file.getParent(), filename);
                Name incorigin = this.origin;
                token = this.st.get();
                if (token.isString()) {
                    incorigin = this.parseName(token.value, Name.root);
                    this.st.getEOL();
                }
                this.included = new Master(newfile, incorigin);
                return this.nextRecord();
            }
            if (s.charAt(0) == '$') {
                throw this.st.exception("Invalid directive: " + s);
            }
            name = this.parseName(s, this.origin);
        }
        s = this.st.getString();
        try {
            ttl = TTL.parseTTL(s);
            s = this.st.getString();
        }
        catch (NumberFormatException e) {
            if (this.last == null && this.defaultTTL < 0L) {
                throw this.st.exception("missing TTL");
            }
            ttl = this.defaultTTL >= 0L ? (long)((int)this.defaultTTL) : this.last.getTTL();
        }
        int dclass = DClass.value(s);
        if (dclass > 0) {
            s = this.st.getString();
        } else {
            dclass = 1;
        }
        int type = Type.value(s);
        if (type < 0) {
            throw this.st.exception("Invalid type '" + s + "'");
        }
        this.last = Record.fromString(name, type, dclass, ttl, this.st, this.origin);
        return this.last;
    }
}

