/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class Name
implements Comparable {
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_MASK = 192;
    private byte[] name;
    private long offsets;
    private int hashcode;
    private static final byte[] emptyLabel = new byte[]{0};
    private static final byte[] wildLabel = new byte[]{1, 42};
    public static final Name root;
    public static final Name empty;
    private static final int MAXNAME = 255;
    private static final int MAXLABEL = 63;
    private static final int MAXLABELS = 128;
    private static final int MAXOFFSETS = 7;
    private static final DecimalFormat byteFormat;
    private static final byte[] lowercase;
    private static final Name wild;

    private Name() {
    }

    private final void dump(String prefix) {
        String s;
        try {
            s = this.toString();
        }
        catch (Exception e) {
            s = "<unprintable>";
        }
        System.out.println(prefix + ": " + s);
        int labels = this.labels();
        int i = 0;
        while (i < labels) {
            System.out.print(this.offset(i) + " ");
            ++i;
        }
        System.out.println("");
        int i2 = 0;
        while (this.name != null && i2 < this.name.length) {
            System.out.print((this.name[i2] & 0xFF) + " ");
            ++i2;
        }
        System.out.println("");
    }

    private final void setoffset(int n, int offset) {
        if (n >= 7) {
            return;
        }
        int shift = 8 * (7 - n);
        this.offsets &= 255L << shift ^ 0xFFFFFFFFFFFFFFFFL;
        this.offsets |= (long)offset << shift;
    }

    private final int offset(int n) {
        if (n < 0 || n >= this.getlabels()) {
            throw new IllegalArgumentException("label out of range");
        }
        if (n < 7) {
            int shift = 8 * (7 - n);
            return (int)(this.offsets >>> shift) & 0xFF;
        }
        int pos = this.offset(6);
        int i = 6;
        while (i < n) {
            pos += this.name[pos] + 1;
            ++i;
        }
        return pos;
    }

    private final void setlabels(byte labels) {
        this.offsets &= 0xFFFFFFFFFFFFFF00L;
        this.offsets |= (long)labels;
    }

    private final byte getlabels() {
        return (byte)(this.offsets & 0xFFL);
    }

    private static final void copy(Name src, Name dst) {
        dst.name = src.name;
        dst.offsets = src.offsets;
    }

    private final void append(byte[] array, int start, int n) throws NameTooLongException {
        int length = this.name == null ? 0 : this.name.length - this.offset(0);
        int alength = 0;
        int i = 0;
        int pos = start;
        while (i < n) {
            int len = array[pos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            pos += ++len;
            alength += len;
            ++i;
        }
        int newlength = length + alength;
        if (newlength > 255) {
            throw new NameTooLongException();
        }
        byte labels = this.getlabels();
        int newlabels = labels + n;
        if (newlabels > 128) {
            throw new IllegalStateException("too many labels");
        }
        byte[] newname = new byte[newlength];
        if (length != 0) {
            System.arraycopy(this.name, this.offset(0), newname, 0, length);
        }
        System.arraycopy(array, start, newname, length, alength);
        this.name = newname;
        int i2 = 0;
        int pos2 = length;
        while (i2 < n) {
            this.setoffset(labels + i2, pos2);
            pos2 += newname[pos2] + 1;
            ++i2;
        }
        this.setlabels((byte)newlabels);
    }

    private static TextParseException parseException(String str, String message) {
        return new TextParseException("'" + str + "': " + message);
    }

    private final void appendFromString(String fullName, byte[] array, int start, int n) throws TextParseException {
        try {
            this.append(array, start, n);
        }
        catch (NameTooLongException e) {
            throw Name.parseException(fullName, "Name too long");
        }
    }

    private final void appendSafe(byte[] array, int start, int n) {
        try {
            this.append(array, start, n);
        }
        catch (NameTooLongException e) {}
    }

    public Name(String s, Name origin) throws TextParseException {
        if (s.equals("")) {
            throw Name.parseException(s, "empty name");
        }
        if (s.equals("@")) {
            if (origin == null) {
                return;
            }
            Name.copy(origin, this);
            return;
        }
        if (s.equals(".")) {
            Name.copy(root, this);
            return;
        }
        int labelstart = -1;
        int pos = 1;
        byte[] label = new byte[64];
        boolean escaped = false;
        int digits = 0;
        int intval = 0;
        boolean absolute = false;
        int i = 0;
        while (i < s.length()) {
            block21: {
                byte b;
                block19: {
                    block22: {
                        block20: {
                            b = (byte)s.charAt(i);
                            if (!escaped) break block19;
                            if (b < 48 || b > 57 || digits >= 3) break block20;
                            ++digits;
                            intval *= 10;
                            if ((intval += b - 48) > 255) {
                                throw Name.parseException(s, "bad escape");
                            }
                            if (digits < 3) break block21;
                            b = (byte)intval;
                            break block22;
                        }
                        if (digits > 0 && digits < 3) {
                            throw Name.parseException(s, "bad escape");
                        }
                    }
                    if (pos > 63) {
                        throw Name.parseException(s, "label too long");
                    }
                    labelstart = pos;
                    label[pos++] = b;
                    escaped = false;
                    break block21;
                }
                if (b == 92) {
                    escaped = true;
                    digits = 0;
                    intval = 0;
                } else if (b == 46) {
                    if (labelstart == -1) {
                        throw Name.parseException(s, "invalid empty label");
                    }
                    label[0] = (byte)(pos - 1);
                    this.appendFromString(s, label, 0, 1);
                    labelstart = -1;
                    pos = 1;
                } else {
                    if (labelstart == -1) {
                        labelstart = i;
                    }
                    if (pos > 63) {
                        throw Name.parseException(s, "label too long");
                    }
                    label[pos++] = b;
                }
            }
            ++i;
        }
        if (digits > 0 && digits < 3) {
            throw Name.parseException(s, "bad escape");
        }
        if (labelstart == -1) {
            this.appendFromString(s, emptyLabel, 0, 1);
            absolute = true;
        } else {
            label[0] = (byte)(pos - 1);
            this.appendFromString(s, label, 0, 1);
        }
        if (origin != null && !absolute) {
            this.appendFromString(s, origin.name, 0, origin.getlabels());
        }
    }

    public Name(String s) throws TextParseException {
        this(s, null);
    }

    public static Name fromString(String s, Name origin) throws TextParseException {
        if (s.equals("@") && origin != null) {
            return origin;
        }
        if (s.equals(".")) {
            return root;
        }
        return new Name(s, origin);
    }

    public static Name fromString(String s) throws TextParseException {
        return Name.fromString(s, null);
    }

    public static Name fromConstantString(String s) {
        try {
            return Name.fromString(s, null);
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("Invalid name '" + s + "'");
        }
    }

    Name(DataByteInputStream in) throws IOException {
        boolean done = false;
        byte[] label = new byte[64];
        int savedpos = -1;
        while (!done) {
            int len = in.readUnsignedByte();
            switch (len & 0xC0) {
                case 0: {
                    if (this.getlabels() >= 128) {
                        throw new WireParseException("too many labels");
                    }
                    if (len == 0) {
                        this.append(emptyLabel, 0, 1);
                        done = true;
                        break;
                    }
                    label[0] = (byte)len;
                    in.readArray(label, 1, len);
                    this.append(label, 0, 1);
                    break;
                }
                case 192: {
                    int currentpos;
                    int pos = in.readUnsignedByte();
                    pos += (len & 0xFFFFFF3F) << 8;
                    if (Options.check("verbosecompression")) {
                        System.err.println("currently " + in.getPos() + ", pointer to " + pos);
                    }
                    if (pos >= (currentpos = in.getPos())) {
                        throw new WireParseException("bad compression");
                    }
                    if (savedpos == -1) {
                        savedpos = currentpos;
                    }
                    in.setPos(pos);
                    if (!Options.check("verbosecompression")) break;
                    System.err.println("current name '" + this + "', seeking to " + pos);
                    break;
                }
            }
        }
        if (savedpos != -1) {
            in.setPos(savedpos);
        }
    }

    public Name(byte[] b) throws IOException {
        this(new DataByteInputStream(b));
    }

    public Name(Name src, int n) {
        byte slabels = src.labels();
        if (n > slabels) {
            throw new IllegalArgumentException("attempted to remove too many labels");
        }
        this.name = src.name;
        this.setlabels((byte)(slabels - n));
        int i = 0;
        while (i < 7 && i < slabels - n) {
            this.setoffset(i, src.offset(i + n));
            ++i;
        }
    }

    public static Name concatenate(Name prefix, Name suffix) throws NameTooLongException {
        if (prefix.isAbsolute()) {
            return prefix;
        }
        Name newname = new Name();
        Name.copy(prefix, newname);
        newname.append(suffix.name, suffix.offset(0), suffix.getlabels());
        return newname;
    }

    public Name relativize(Name origin) {
        if (origin == null || !this.subdomain(origin)) {
            return this;
        }
        Name newname = new Name();
        Name.copy(this, newname);
        int length = this.length() - origin.length();
        int labels = newname.labels() - origin.labels();
        newname.setlabels((byte)labels);
        newname.name = new byte[length];
        System.arraycopy(this.name, this.offset(0), newname.name, 0, length);
        return newname;
    }

    public Name wild(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("must replace 1 or more labels");
        }
        try {
            Name newname = new Name();
            Name.copy(wild, newname);
            newname.append(this.name, this.offset(n), this.getlabels() - n);
            return newname;
        }
        catch (NameTooLongException e) {
            throw new IllegalStateException("Name.wild: concatenate failed");
        }
    }

    public Name fromDNAME(DNAMERecord dname) throws NameTooLongException {
        Name dnameowner = dname.getName();
        Name dnametarget = dname.getTarget();
        if (!this.subdomain(dnameowner)) {
            return null;
        }
        int plabels = this.labels() - dnameowner.labels();
        int plength = this.length() - dnameowner.length();
        int pstart = this.offset(0);
        byte dlabels = dnametarget.labels();
        short dlength = dnametarget.length();
        if (plength + dlength > 255) {
            throw new NameTooLongException();
        }
        Name newname = new Name();
        newname.setlabels((byte)(plabels + dlabels));
        newname.name = new byte[plength + dlength];
        System.arraycopy(this.name, pstart, newname.name, 0, plength);
        System.arraycopy(dnametarget.name, 0, newname.name, plength, dlength);
        int i = 0;
        int pos = 0;
        while (i < 7 && i < plabels + dlabels) {
            newname.setoffset(i, pos);
            pos += newname.name[pos] + 1;
            ++i;
        }
        return newname;
    }

    public boolean isWild() {
        if (this.labels() == 0) {
            return false;
        }
        return this.name[0] == 1 && this.name[1] == 42;
    }

    public boolean isAbsolute() {
        if (this.labels() == 0) {
            return false;
        }
        return this.name[this.name.length - 1] == 0;
    }

    public short length() {
        return (short)(this.name.length - this.offset(0));
    }

    public byte labels() {
        return this.getlabels();
    }

    public boolean subdomain(Name domain) {
        byte labels = this.labels();
        byte dlabels = domain.labels();
        if (dlabels > labels) {
            return false;
        }
        if (dlabels == labels) {
            return this.equals(domain);
        }
        return domain.equals(this.name, this.offset(labels - dlabels));
    }

    private String byteString(byte[] array, int pos) {
        StringBuffer sb = new StringBuffer();
        byte len = array[pos++];
        int i = pos;
        while (i < pos + len) {
            short b = (short)(array[i] & 0xFF);
            if (b <= 32 || b >= 127) {
                sb.append('\\');
                sb.append(byteFormat.format(b));
            } else if (b == 34 || b == 40 || b == 41 || b == 46 || b == 59 || b == 92 || b == 64 || b == 36) {
                sb.append('\\');
                sb.append((char)b);
            } else {
                sb.append((char)b);
            }
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        int labels = this.labels();
        if (labels == 0) {
            return "@";
        }
        if (labels == 1 && this.name[this.offset(0)] == 0) {
            return ".";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int pos = this.offset(0);
        while (i < labels) {
            byte len = this.name[pos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            if (len == 0) break;
            sb.append(this.byteString(this.name, pos));
            sb.append('.');
            pos += 1 + len;
            ++i;
        }
        if (!this.isAbsolute()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public byte[] getLabel(int n) {
        int pos = this.offset(n);
        byte len = (byte)(this.name[pos] + 1);
        byte[] label = new byte[len];
        System.arraycopy(this.name, pos, label, 0, len);
        return label;
    }

    public String getLabelString(int n) {
        int pos = this.offset(n);
        return this.byteString(this.name, pos);
    }

    void toWire(DataByteOutputStream out, Compression c) {
        if (!this.isAbsolute()) {
            throw new IllegalArgumentException("toWire() called on non-absolute name");
        }
        byte labels = this.labels();
        int i = 0;
        while (i < labels - 1) {
            Name tname = i == 0 ? this : new Name(this, i);
            int pos = -1;
            if (c != null) {
                pos = c.get(tname);
            }
            if (pos >= 0) {
                out.writeShort(pos |= 0xC000);
                return;
            }
            if (c != null) {
                c.add(out.getPos(), tname);
            }
            out.writeString(this.name, this.offset(i));
            ++i;
        }
        out.writeByte(0);
    }

    public byte[] toWire() {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out, null);
        return out.toByteArray();
    }

    void toWireCanonical(DataByteOutputStream out) {
        byte[] b = this.toWireCanonical();
        out.writeArray(b);
    }

    public byte[] toWireCanonical() {
        int labels = this.labels();
        if (labels == 0) {
            return new byte[0];
        }
        byte[] b = new byte[this.name.length - this.offset(0)];
        int i = 0;
        int pos = this.offset(0);
        while (i < labels) {
            int len = this.name[pos];
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            b[pos] = this.name[pos++];
            int j = 0;
            while (j < len) {
                b[pos] = lowercase[this.name[pos++] & 0xFF];
                ++j;
            }
            ++i;
        }
        return b;
    }

    void toWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (canonical) {
            this.toWireCanonical(out);
        } else {
            this.toWire(out, c);
        }
    }

    private final boolean equals(byte[] b, int bpos) {
        int labels = this.labels();
        int i = 0;
        int pos = this.offset(0);
        while (i < labels) {
            if (this.name[pos] != b[bpos]) {
                return false;
            }
            int len = this.name[pos++];
            ++bpos;
            if (len > 63) {
                throw new IllegalStateException("invalid label");
            }
            int j = 0;
            while (j < len) {
                if (lowercase[this.name[pos++] & 0xFF] != lowercase[b[bpos++] & 0xFF]) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null || !(arg instanceof Name)) {
            return false;
        }
        Name d = (Name)arg;
        if (d.hashcode == 0) {
            d.hashCode();
        }
        if (this.hashcode == 0) {
            this.hashCode();
        }
        if (d.hashcode != this.hashcode) {
            return false;
        }
        if (d.labels() != this.labels()) {
            return false;
        }
        return this.equals(d.name, d.offset(0));
    }

    public int hashCode() {
        if (this.hashcode != 0) {
            return this.hashcode;
        }
        int code = 0;
        int i = this.offset(0);
        while (i < this.name.length) {
            code += (code << 3) + lowercase[this.name[i] & 0xFF];
            ++i;
        }
        this.hashcode = code;
        return this.hashcode;
    }

    public int compareTo(Object o) {
        int alabels;
        Name arg = (Name)o;
        if (this == arg) {
            return 0;
        }
        int labels = this.labels();
        int compares = labels > (alabels = arg.labels()) ? alabels : labels;
        int i = 1;
        while (i <= compares) {
            int start = this.offset(labels - i);
            int astart = arg.offset(alabels - i);
            int length = this.name[start];
            byte alength = arg.name[astart];
            int j = 0;
            while (j < length && j < alength) {
                int n = lowercase[this.name[j + start + 1] & 0xFF] - lowercase[arg.name[j + astart + 1] & 0xFF];
                if (n != 0) {
                    return n;
                }
                ++j;
            }
            if (length != alength) {
                return length - alength;
            }
            ++i;
        }
        return labels - alabels;
    }

    static {
        byteFormat = new DecimalFormat();
        lowercase = new byte[256];
        byteFormat.setMinimumIntegerDigits(3);
        int i = 0;
        while (i < lowercase.length) {
            Name.lowercase[i] = i < 65 || i > 90 ? (byte)i : (byte)(i - 65 + 97);
            ++i;
        }
        root = new Name();
        empty = new Name();
        wild = new Name();
        root.appendSafe(emptyLabel, 0, 1);
        wild.appendSafe(wildLabel, 0, 1);
    }
}

