/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.Arrays;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.TTL;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.Type;
import org.xbill.DNS.UNKRecord;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base16;

public abstract class Record
implements Cloneable,
Comparable {
    protected Name name;
    protected int type;
    protected int dclass;
    protected long ttl;
    private boolean empty;
    private static final Record[] knownRecords = new Record[256];
    private static final Class[] emptyClassArray = new Class[0];
    private static final Object[] emptyObjectArray = new Object[0];
    private static final DecimalFormat byteFormat = new DecimalFormat();
    static /* synthetic */ Class class$org$xbill$DNS$Record;

    protected Record() {
    }

    Record(Name name, int type, int dclass, long ttl) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(type);
        DClass.check(dclass);
        TTL.check(ttl);
        this.name = name;
        this.type = type;
        this.dclass = dclass;
        this.ttl = ttl;
    }

    private static final Record getTypedObject(int type) {
        block10: {
            if (type < 0 || type > knownRecords.length) {
                return UNKRecord.getMember();
            }
            if (knownRecords[type] != null) {
                return knownRecords[type];
            }
            String s = (class$org$xbill$DNS$Record == null ? (class$org$xbill$DNS$Record = Record.class$("org.xbill.DNS.Record")) : class$org$xbill$DNS$Record).getName();
            StringBuffer sb = new StringBuffer(s);
            sb.insert(s.lastIndexOf("Record"), Type.string(type));
            try {
                Class<?> c = Class.forName(sb.toString());
                Method m = c.getDeclaredMethod("getMember", emptyClassArray);
                Record.knownRecords[type] = (Record)m.invoke(null, emptyObjectArray);
            }
            catch (ClassNotFoundException e) {
            }
            catch (InvocationTargetException e) {
                if (Options.check("verbose")) {
                    System.err.println(e);
                }
            }
            catch (NoSuchMethodException e) {
                if (Options.check("verbose")) {
                    System.err.println(e);
                }
            }
            catch (IllegalAccessException e) {
                if (!Options.check("verbose")) break block10;
                System.err.println(e);
            }
        }
        if (knownRecords[type] == null) {
            Record.knownRecords[type] = UNKRecord.getMember();
        }
        return knownRecords[type];
    }

    abstract Record rrFromWire(Name var1, int var2, int var3, long var4, int var6, DataByteInputStream var7) throws IOException;

    private static Record newRecord(Name name, int type, int dclass, long ttl, int length, DataByteInputStream in) throws IOException {
        Record rec = Record.getTypedObject(type);
        int recstart = in == null ? 0 : in.getPos();
        rec = rec.rrFromWire(name, type, dclass, ttl, length, in);
        if (in == null) {
            rec.empty = true;
        }
        if (in != null && in.getPos() - recstart != length) {
            throw new IOException("Invalid record length");
        }
        return rec;
    }

    public static Record newRecord(Name name, int type, int dclass, long ttl, int length, byte[] data) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(type);
        DClass.check(dclass);
        TTL.check(ttl);
        DataByteInputStream dbs = data != null ? new DataByteInputStream(data) : null;
        try {
            return Record.newRecord(name, type, dclass, ttl, length, dbs);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Record newRecord(Name name, int type, int dclass, long ttl, byte[] data) {
        return Record.newRecord(name, type, dclass, ttl, data.length, data);
    }

    public static Record newRecord(Name name, int type, int dclass, long ttl) {
        return Record.newRecord(name, type, dclass, ttl, 0, (byte[])null);
    }

    public static Record newRecord(Name name, int type, int dclass) {
        return Record.newRecord(name, type, dclass, 0L, 0, (byte[])null);
    }

    static Record fromWire(DataByteInputStream in, int section) throws IOException {
        int start = in.getPos();
        Name name = new Name(in);
        int type = in.readUnsignedShort();
        int dclass = in.readUnsignedShort();
        if (section == 0) {
            return Record.newRecord(name, type, dclass);
        }
        long ttl = in.readUnsignedInt();
        int length = in.readUnsignedShort();
        if (length == 0) {
            return Record.newRecord(name, type, dclass, ttl);
        }
        Record rec = Record.newRecord(name, type, dclass, ttl, length, in);
        return rec;
    }

    public static Record fromWire(byte[] b, int section) throws IOException {
        DataByteInputStream in = new DataByteInputStream(b);
        return Record.fromWire(in, section);
    }

    void toWire(DataByteOutputStream out, int section, Compression c) {
        int start = out.getPos();
        this.name.toWire(out, c);
        out.writeShort(this.type);
        out.writeShort(this.dclass);
        if (section == 0) {
            return;
        }
        out.writeUnsignedInt(this.ttl);
        int lengthPosition = out.getPos();
        out.writeShort(0);
        if (!this.empty) {
            this.rrToWire(out, c, false);
        }
        out.writeShortAt(out.getPos() - lengthPosition - 2, lengthPosition);
    }

    public byte[] toWire(int section) {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out, section, null);
        return out.toByteArray();
    }

    private void toWireCanonical(DataByteOutputStream out, boolean noTTL) {
        this.name.toWireCanonical(out);
        out.writeShort(this.type);
        out.writeShort(this.dclass);
        if (noTTL) {
            out.writeUnsignedInt(0L);
        } else {
            out.writeUnsignedInt(this.ttl);
        }
        int lengthPosition = out.getPos();
        out.writeShort(0);
        if (!this.empty) {
            this.rrToWire(out, null, true);
        }
        out.writeShortAt(out.getPos() - lengthPosition - 2, lengthPosition);
    }

    private byte[] toWireCanonical(boolean noTTL) {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWireCanonical(out, noTTL);
        return out.toByteArray();
    }

    public byte[] toWireCanonical() {
        return this.toWireCanonical(false);
    }

    public byte[] rdataToWireCanonical() {
        DataByteOutputStream out = new DataByteOutputStream();
        this.rrToWire(out, null, true);
        return out.toByteArray();
    }

    public abstract String rdataToString();

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (sb.length() < 8) {
            sb.append("\t");
        }
        if (sb.length() < 16) {
            sb.append("\t");
        }
        sb.append("\t");
        if (Options.check("BINDTTL")) {
            sb.append(TTL.format(this.ttl));
        } else {
            sb.append(this.ttl);
        }
        sb.append("\t");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            sb.append(DClass.string(this.dclass));
            sb.append("\t");
        }
        sb.append(Type.string(this.type));
        if (!this.empty) {
            sb.append("\t");
            sb.append(this.rdataToString());
        }
        return sb.toString();
    }

    abstract Record rdataFromString(Name var1, int var2, long var3, Tokenizer var5, Name var6) throws IOException;

    protected static String remainingStrings(Tokenizer st) throws IOException {
        Tokenizer.Token t;
        StringBuffer sb = null;
        while ((t = st.get()).isString()) {
            if (sb == null) {
                sb = new StringBuffer();
            }
            sb.append(t.value);
        }
        st.unget();
        if (sb == null) {
            return null;
        }
        return sb.toString();
    }

    protected static byte[] byteArrayFromString(String s) throws TextParseException {
        byte[] array = s.getBytes();
        boolean escaped = false;
        boolean hasEscapes = false;
        int i = 0;
        while (i < array.length) {
            if (array[i] == 92) {
                hasEscapes = true;
                break;
            }
            ++i;
        }
        if (!hasEscapes) {
            return array;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int digits = 0;
        int intval = 0;
        int i2 = 0;
        while (i2 < array.length) {
            block11: {
                block9: {
                    byte b;
                    block12: {
                        block10: {
                            b = array[i2];
                            if (!escaped) break block9;
                            if (b < 48 || b > 57 || digits >= 3) break block10;
                            ++digits;
                            intval *= 10;
                            if ((intval += b - 48) > 255) {
                                throw new TextParseException("bad escape");
                            }
                            if (digits < 3) break block11;
                            b = (byte)intval;
                            break block12;
                        }
                        if (digits > 0 && digits < 3) {
                            throw new TextParseException("bad escape");
                        }
                    }
                    os.write(b);
                    escaped = false;
                    break block11;
                }
                if (array[i2] == 92) {
                    escaped = true;
                    digits = 0;
                    intval = 0;
                } else {
                    os.write(array[i2]);
                }
            }
            ++i2;
        }
        if (digits > 0 && digits < 3) {
            throw new TextParseException("bad escape");
        }
        return os.toByteArray();
    }

    protected static String byteArrayToString(byte[] array, boolean quote) {
        StringBuffer sb = new StringBuffer();
        if (quote) {
            sb.append('\"');
        }
        int i = 0;
        while (i < array.length) {
            short b = (short)(array[i] & 0xFF);
            if (b < 32 || b >= 127) {
                sb.append('\\');
                sb.append(byteFormat.format(b));
            } else if (b == 34 || b == 59 || b == 92) {
                sb.append('\\');
                sb.append((char)b);
            } else {
                sb.append((char)b);
            }
            ++i;
        }
        if (quote) {
            sb.append('\"');
        }
        return sb.toString();
    }

    public static Record fromString(Name name, int type, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Type.check(type);
        DClass.check(dclass);
        TTL.check(ttl);
        Tokenizer.Token t = st.get();
        if (t.type == 3 && t.value.equals("\\#")) {
            String s;
            byte[] data;
            int length = st.getUInt16();
            if (length != (data = base16.fromString(s = Record.remainingStrings(st))).length) {
                throw st.exception("invalid unknown RR encoding: length mismatch");
            }
            DataByteInputStream in = new DataByteInputStream(data);
            return Record.newRecord(name, type, dclass, ttl, length, in);
        }
        st.unget();
        Record rec = Record.getTypedObject(type);
        rec = rec.rdataFromString(name, dclass, ttl, st, origin);
        t = st.get();
        if (t.type != 1 && t.type != 0) {
            throw st.exception("unexpected tokens at end of record");
        }
        return rec;
    }

    public static Record fromString(Name name, int type, int dclass, long ttl, String s, Name origin) throws IOException {
        return Record.fromString(name, type, dclass, ttl, new Tokenizer(s), origin);
    }

    public Name getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getRRsetType() {
        if (this.type == 24) {
            SIGRecord sig = (SIGRecord)this;
            return sig.getTypeCovered();
        }
        return this.type;
    }

    public int getDClass() {
        return this.dclass;
    }

    public long getTTL() {
        return this.ttl;
    }

    abstract void rrToWire(DataByteOutputStream var1, Compression var2, boolean var3);

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof Record)) {
            return false;
        }
        Record r = (Record)arg;
        if (this.type != r.type || this.dclass != r.dclass || !this.name.equals(r.name)) {
            return false;
        }
        byte[] array1 = this.rdataToWireCanonical();
        byte[] array2 = r.rdataToWireCanonical();
        return Arrays.equals(array1, array2);
    }

    public int hashCode() {
        byte[] array = this.toWireCanonical(true);
        int code = 0;
        int i = 0;
        while (i < array.length) {
            code += (code << 3) + (array[i] & 0xFF);
            ++i;
        }
        return code;
    }

    private Record cloneRecord() {
        try {
            return (Record)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public Record withName(Name name) {
        if (!name.isAbsolute()) {
            throw new RelativeNameException(name);
        }
        Record rec = this.cloneRecord();
        rec.name = name;
        return rec;
    }

    Record withDClass(int dclass, long ttl) {
        Record rec = this.cloneRecord();
        rec.dclass = dclass;
        rec.ttl = ttl;
        return rec;
    }

    public int compareTo(Object o) {
        Record arg = (Record)o;
        if (this == arg) {
            return 0;
        }
        int n = this.name.compareTo(arg.name);
        if (n != 0) {
            return n;
        }
        n = this.dclass - arg.dclass;
        if (n != 0) {
            return n;
        }
        n = this.type - arg.type;
        if (n != 0) {
            return n;
        }
        byte[] rdata1 = this.rdataToWireCanonical();
        byte[] rdata2 = arg.rdataToWireCanonical();
        int i = 0;
        while (i < rdata1.length && i < rdata2.length) {
            n = (rdata1[i] & 0xFF) - (rdata2[i] & 0xFF);
            if (n != 0) {
                return n;
            }
            ++i;
        }
        return rdata1.length - rdata2.length;
    }

    public Name getAdditionalName() {
        return null;
    }

    static void checkU8(String field, int val) {
        if (val < 0 || val > 255) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + "must be an unsigned 8 " + "bit value");
        }
    }

    static void checkU16(String field, int val) {
        if (val < 0 || val > 65535) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + "must be an unsigned 16 " + "bit value");
        }
    }

    static void checkU32(String field, long val) {
        if (val < 0L || val > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("\"" + field + "\" " + val + "must be an unsigned 32 " + "bit value");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        byteFormat.setMinimumIntegerDigits(3);
    }
}

