/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.RelativeNameException;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base64;

public class TSIGRecord
extends Record {
    private static TSIGRecord member = new TSIGRecord();
    private Name alg;
    private Date timeSigned;
    private int fudge;
    private byte[] signature;
    private int originalID;
    private int error;
    private byte[] other;

    private TSIGRecord() {
    }

    private TSIGRecord(Name name, int dclass, long ttl) {
        super(name, 250, dclass, ttl);
    }

    static TSIGRecord getMember() {
        return member;
    }

    public TSIGRecord(Name name, int dclass, long ttl, Name alg, Date timeSigned, int fudge, byte[] signature, int originalID, int error, byte[] other) {
        this(name, dclass, ttl);
        if (!alg.isAbsolute()) {
            throw new RelativeNameException(alg);
        }
        Record.checkU16("fudge", fudge);
        Record.checkU16("error", error);
        this.alg = alg;
        this.timeSigned = timeSigned;
        this.fudge = fudge;
        this.signature = signature;
        this.originalID = originalID;
        this.error = error;
        this.other = other;
    }

    Record rrFromWire(Name name, int type, int dclass, long ttl, int length, DataByteInputStream in) throws IOException {
        TSIGRecord rec = new TSIGRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.alg = new Name(in);
        long timeHigh = in.readUnsignedShort();
        long timeLow = in.readUnsignedInt();
        long time = (timeHigh << 32) + timeLow;
        rec.timeSigned = new Date(time * 1000L);
        rec.fudge = in.readUnsignedShort();
        int sigLen = in.readUnsignedShort();
        rec.signature = new byte[sigLen];
        in.read(rec.signature);
        rec.originalID = in.readUnsignedShort();
        rec.error = in.readShort();
        int otherLen = in.readUnsignedShort();
        if (otherLen > 0) {
            rec.other = new byte[otherLen];
            in.read(rec.other);
        } else {
            rec.other = null;
        }
        return rec;
    }

    Record rdataFromString(Name name, int dclass, long ttl, Tokenizer st, Name origin) throws IOException {
        throw st.exception("no text format defined for TSIG");
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.alg == null) {
            return sb.toString();
        }
        sb.append(this.alg);
        sb.append(" ");
        if (Options.check("multiline")) {
            sb.append("(\n\t");
        }
        sb.append(this.timeSigned.getTime() / 1000L);
        sb.append(" ");
        sb.append(this.fudge);
        sb.append(" ");
        sb.append(this.signature.length);
        if (Options.check("multiline")) {
            sb.append("\n");
            sb.append(base64.formatString(this.signature, 64, "\t", false));
        } else {
            sb.append(" ");
            sb.append(base64.toString(this.signature));
        }
        sb.append(Rcode.TSIGstring(this.error));
        sb.append(" ");
        if (this.other == null) {
            sb.append(0);
        } else {
            sb.append(this.other.length);
            if (Options.check("multiline")) {
                sb.append("\n\n\n\t");
            } else {
                sb.append(" ");
            }
            if (this.error == 18) {
                if (this.other.length != 6) {
                    sb.append("<invalid BADTIME other data>");
                } else {
                    long time = ((this.other[0] & 0xFF) << 40) + ((this.other[1] & 0xFF) << 32) + ((this.other[2] & 0xFF) << 24) + ((this.other[3] & 0xFF) << 16) + ((this.other[4] & 0xFF) << 8) + (this.other[5] & 0xFF);
                    sb.append("<server time: ");
                    sb.append(new Date(time * 1000L));
                    sb.append(">");
                }
            } else {
                sb.append(base64.toString(this.other));
            }
            sb.append(">");
        }
        if (Options.check("multiline")) {
            sb.append(" )");
        }
        return sb.toString();
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public int getFudge() {
        return this.fudge;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public int getError() {
        return this.error;
    }

    public byte[] getOther() {
        return this.other;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.alg == null) {
            return;
        }
        this.alg.toWire(out, null, canonical);
        long time = this.timeSigned.getTime() / 1000L;
        int timeHigh = (int)(time >> 32);
        long timeLow = time & 0xFFFFFFFFL;
        out.writeUnsignedShort(timeHigh);
        out.writeUnsignedInt(timeLow);
        out.writeUnsignedShort(this.fudge);
        out.writeUnsignedShort(this.signature.length);
        out.writeArray(this.signature);
        out.writeShort(this.originalID);
        out.writeShort(this.error);
        if (this.other != null) {
            out.writeUnsignedShort(this.other.length);
            out.writeArray(this.other);
        } else {
            out.writeShort(0);
        }
    }
}

