/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.InvalidTTLException;

public final class TTL {
    private TTL() {
    }

    static void check(long i) {
        if (i < 0L || i > 0xFFFFFFFFL) {
            throw new InvalidTTLException(i);
        }
    }

    public static long parseTTL(String s) {
        if (s == null || !Character.isDigit(s.charAt(0))) {
            throw new NumberFormatException();
        }
        long value = 0L;
        long ttl = 0L;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            long oldvalue = value;
            if (Character.isDigit(c)) {
                value = value * 10L + (long)Character.getNumericValue(c);
            }
            if (value < oldvalue) {
                throw new NumberFormatException();
            }
            switch (Character.toUpperCase(c)) {
                case 'W': {
                    value *= 7L;
                }
                case 'D': {
                    value *= 24L;
                }
                case 'H': {
                    value *= 60L;
                }
                case 'M': {
                    value *= 60L;
                }
                case 'S': {
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
            value = 0L;
            if ((ttl += value) > 0xFFFFFFFFL) {
                throw new NumberFormatException();
            }
            ++i;
        }
        if (ttl == 0L && (ttl = value) > 0xFFFFFFFFL) {
            throw new NumberFormatException();
        }
        return ttl;
    }

    public static String format(long ttl) {
        TTL.check(ttl);
        StringBuffer sb = new StringBuffer();
        long secs = ttl % 60L;
        long mins = (ttl /= 60L) % 60L;
        long hours = (ttl /= 60L) % 24L;
        long days = (ttl /= 24L) % 7L;
        long weeks = ttl /= 7L;
        if (weeks > 0L) {
            sb.append(weeks + "W");
        }
        if (days > 0L) {
            sb.append(days + "D");
        }
        if (hours > 0L) {
            sb.append(hours + "H");
        }
        if (mins > 0L) {
            sb.append(mins + "M");
        }
        if (secs > 0L || weeks == 0L && days == 0L && hours == 0L && mins == 0L) {
            sb.append(secs + "S");
        }
        return sb.toString();
    }
}

