/*
 * Decompiled with CFR 0.152.
 */
package jcckit.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Stack;
import jcckit.graphic.BasicGraphicalElement;
import jcckit.graphic.ClippingRectangle;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.FillAttributes;
import jcckit.graphic.FontStyle;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalCompositeRenderer;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Oval;
import jcckit.graphic.OvalRenderer;
import jcckit.graphic.Polygon;
import jcckit.graphic.PolygonRenderer;
import jcckit.graphic.Rectangle;
import jcckit.graphic.RectangleRenderer;
import jcckit.graphic.Text;
import jcckit.graphic.TextAttributes;
import jcckit.graphic.TextRenderer;
import jcckit.renderer.Transformation;

public class GraphicsRenderer
implements GraphicalCompositeRenderer,
PolygonRenderer,
OvalRenderer,
TextRenderer,
RectangleRenderer {
    private static final String DEFAULT_FONT_NAME = "SansSerif";
    private static final FontStyle DEFAULT_FONT_STYLE = FontStyle.NORMAL;
    private static final int DEFAULT_FONT_SIZE = 12;
    private final Stack _graphicsStack = new Stack();
    private Transformation _t;
    private Component _component;
    private Graphics _graphics;
    private Color _defaultColor;

    static Font createFont(TextAttributes attributes, int size) {
        FontStyle fontStyle;
        String fontName = attributes.getFontName();
        if (fontName == null) {
            fontName = DEFAULT_FONT_NAME;
        }
        if ((fontStyle = attributes.getFontStyle()) == null) {
            fontStyle = DEFAULT_FONT_STYLE;
        }
        int style = 0;
        if (fontStyle == FontStyle.BOLD) {
            style = 1;
        } else if (fontStyle == FontStyle.ITALIC) {
            style = 2;
        } else if (fontStyle == FontStyle.BOLD_ITALIC) {
            style = 3;
        }
        if (size == 0) {
            size = 12;
        }
        return new Font(fontName, style, size);
    }

    public GraphicsRenderer init(Graphics graphics, Component component, Transformation transformation) {
        this._graphics = graphics;
        this._component = component;
        this._t = transformation;
        this._defaultColor = graphics.getColor();
        return this;
    }

    public void startRendering(GraphicalComposite composite) {
        ClippingShape shape = composite.getClippingShape();
        if (shape != null) {
            this._graphicsStack.push(this._graphics);
            this._graphics = this._graphics.create();
            ClippingRectangle rect = shape.getBoundingBox();
            int x = this._t.transformX(rect.getMinX());
            int y = this._t.transformY(rect.getMaxY());
            this._graphics.setClip(x, y, this._t.transformX(rect.getMaxX()) - x, this._t.transformY(rect.getMinY()) - y);
        }
    }

    public void finishRendering(GraphicalComposite composite) {
        if (composite.getClippingShape() != null) {
            this._graphics = (Graphics)this._graphicsStack.pop();
        }
    }

    public void render(Polygon polygon) {
        int numberOfPoints = polygon.getNumberOfPoints();
        if (numberOfPoints > 0) {
            Color currentColor = this._graphics.getColor();
            int[] xPoints = new int[numberOfPoints];
            int[] yPoints = new int[numberOfPoints];
            for (int i = 0; i < numberOfPoints; ++i) {
                xPoints[i] = this._t.transformX(polygon.getPoint(i).getX());
                yPoints[i] = this._t.transformY(polygon.getPoint(i).getY());
            }
            Color color = this.getFillColor(polygon);
            if (color != null) {
                this._graphics.setColor(color);
                this._graphics.fillPolygon(xPoints, yPoints, numberOfPoints);
            }
            if ((color = this.getLineColor(polygon)) != null) {
                this._graphics.setColor(color);
                if (polygon.isClosed()) {
                    this._graphics.drawPolygon(xPoints, yPoints, numberOfPoints);
                } else {
                    this._graphics.drawPolyline(xPoints, yPoints, numberOfPoints);
                }
            }
            this._graphics.setColor(currentColor);
        }
    }

    public void render(Rectangle rectangle) {
        Color currentColor = this._graphics.getColor();
        GraphPoint center = rectangle.getCenter();
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        int x = this._t.transformX(center.getX() - 0.5 * width);
        int y = this._t.transformY(center.getY() + 0.5 * height);
        int w = this._t.transformX(center.getX() + 0.5 * width) - x;
        int h = this._t.transformY(center.getY() - 0.5 * height) - y;
        Color color = this.getFillColor(rectangle);
        if (color != null) {
            this._graphics.setColor(color);
            this._graphics.fillRect(x, y, w, h);
        }
        if ((color = this.getLineColor(rectangle)) != null) {
            this._graphics.setColor(color);
            this._graphics.drawRect(x, y, w, h);
        }
        this._graphics.setColor(currentColor);
    }

    public void render(Oval oval) {
        Color currentColor = this._graphics.getColor();
        GraphPoint center = oval.getCenter();
        double width = oval.getWidth();
        double height = oval.getHeight();
        int x = this._t.transformX(center.getX() - 0.5 * width);
        int y = this._t.transformY(center.getY() + 0.5 * height);
        int w = this._t.transformX(center.getX() + 0.5 * width) - x;
        int h = this._t.transformY(center.getY() - 0.5 * height) - y;
        Color color = this.getFillColor(oval);
        if (color != null) {
            this._graphics.setColor(color);
            this._graphics.fillOval(x, y, w, h);
        }
        if ((color = this.getLineColor(oval)) != null) {
            this._graphics.setColor(color);
            this._graphics.drawOval(x, y, w, h);
        }
        this._graphics.setColor(currentColor);
    }

    private Color getFillColor(BasicGraphicalElement element) {
        Color result = null;
        GraphicAttributes ga = element.getGraphicAttributes();
        if (element.isClosed() && ga instanceof FillAttributes) {
            result = ((FillAttributes)ga).getFillColor();
        }
        return result;
    }

    private Color getLineColor(BasicGraphicalElement element) {
        LineAttributes la;
        Color result = this._defaultColor;
        GraphicAttributes ga = element.getGraphicAttributes();
        if (ga instanceof LineAttributes && ((la = (LineAttributes)ga).getLineColor() != null || this.getFillColor(element) != null)) {
            result = la.getLineColor();
        }
        return result;
    }

    public void render(Text text) {
        GraphicAttributes ga = text.getGraphicAttributes();
        if (ga instanceof TextAttributes) {
            TextAttributes ta = (TextAttributes)ga;
            Color currentColor = this._graphics.getColor();
            int orientation = (int)(ta.getOrientationAngle() / 90.0 + 4.5) % 4;
            Color fontColor = ta.getTextColor();
            if (fontColor == null) {
                fontColor = this._defaultColor;
            }
            this._graphics.setColor(fontColor);
            Font font = GraphicsRenderer.createFont(ta, this._t.transformHeight(ta.getFontSize()));
            this._graphics.setFont(font);
            String str = text.getText();
            FontMetrics metrics = this._graphics.getFontMetrics();
            int ascent = metrics.getAscent();
            int descent = metrics.getDescent();
            int height = ascent + descent;
            int width = metrics.stringWidth(str);
            int xAnchor = ta.getHorizontalAnchor().getFactor();
            int yAnchor = ta.getVerticalAnchor().getFactor();
            int x = this._t.transformX(text.getPosition().getX());
            int y = this._t.transformY(text.getPosition().getY());
            if (orientation == 0) {
                this._graphics.drawString(str, x - width * xAnchor / 2, y + yAnchor * height / 2 - descent);
            } else {
                int yf;
                int xf;
                Image textImage = this.makeImage(str, font, fontColor, orientation - 2, ascent, width, height);
                int n = xf = orientation == 2 ? xAnchor : yAnchor;
                if (orientation != 3) {
                    xf = 2 - xf;
                }
                int n2 = yf = orientation == 2 ? yAnchor : xAnchor;
                if (orientation == 1) {
                    yf = 2 - yf;
                }
                this._graphics.drawImage(textImage, x - xf * textImage.getWidth(null) / 2, y - yf * textImage.getHeight(null) / 2, null);
                textImage.flush();
            }
            this._graphics.setColor(currentColor);
        }
    }

    private Image makeImage(String text, Font font, Color color, int orientation, int ascent, int width, int height) {
        int w = orientation == 0 ? width : height;
        int h = orientation == 0 ? height : width;
        Image img = this._component.createImage(width, height);
        Graphics g = img.getGraphics();
        g.setColor(this._component.getForeground());
        g.setFont(font);
        g.drawString(text, 0, ascent);
        int[] origPixels = new int[width * height];
        try {
            new PixelGrabber(img, 0, 0, width, height, origPixels, 0, width).grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        int background = origPixels[0];
        int o2 = orientation * orientation - 1;
        int index = w * h * ((1 - orientation - o2) / 2) + w * orientation + (o2 - orientation - 1) / 2;
        int dx = o2 + w * orientation;
        int dy = o2 - (w * (h - 1) + 1) * orientation;
        int[] pixels = new int[origPixels.length];
        int fc = 0xFF000000 | color.getRGB();
        int lastCol = width - 1;
        for (int i = 0; i < origPixels.length; ++i) {
            pixels[index] = origPixels[i] == background ? 0 : fc;
            index += i % width == lastCol ? dy : dx;
        }
        return this._component.createImage(new MemoryImageSource(w, h, ColorModel.getRGBdefault(), pixels, 0, w));
    }
}

