/*
 * Decompiled with CFR 0.152.
 */
package jcckit.util;

import java.util.Vector;
import jcckit.util.ConfigParameters;
import jcckit.util.FactoryException;
import jcckit.util.FormatElement;
import jcckit.util.TicLabelFormat;

public class Format
implements TicLabelFormat {
    private final FormatElement[] _formatElements;
    private final Vector _staticParts = new Vector();

    public static Format create(ConfigParameters config, String key) {
        Format result = null;
        String format = config.get(key, null);
        if (format != null && format.length() > 0) {
            try {
                result = new Format(format);
            }
            catch (Exception e) {
                throw new FactoryException(config, key, e);
            }
        }
        return result;
    }

    public Format(String formatString) {
        int i;
        Vector<String> formatElements = new Vector<String>();
        StringBuffer part = new StringBuffer();
        boolean insideFormatElement = false;
        boolean atPercentSymbol = false;
        int n = formatString.length();
        for (i = 0; i < n; ++i) {
            char c = formatString.charAt(i);
            if (insideFormatElement) {
                part.append(c);
                if ("doxfeEgG".indexOf(c) < 0) continue;
                formatElements.addElement(new String(part));
                part.setLength(0);
                insideFormatElement = false;
                continue;
            }
            if (atPercentSymbol) {
                atPercentSymbol = false;
                if (c != '%') {
                    this._staticParts.addElement(new String(part));
                    part.setLength(0);
                    insideFormatElement = true;
                }
                part.append(c);
                if ("doxfeEgG".indexOf(c) < 0) continue;
                formatElements.addElement(new String(part));
                part.setLength(0);
                insideFormatElement = false;
                continue;
            }
            if (c == '%') {
                atPercentSymbol = true;
                continue;
            }
            part.append(c);
        }
        if (insideFormatElement) {
            formatElements.addElement(new String(part));
        } else {
            this._staticParts.addElement(new String(part));
        }
        this._formatElements = new FormatElement[formatElements.size()];
        for (i = 0; i < this._formatElements.length; ++i) {
            this._formatElements[i] = new FormatElement((String)formatElements.elementAt(i));
        }
    }

    public String form(long number) {
        StringBuffer result = new StringBuffer();
        result.append(this._staticParts.elementAt(0));
        if (this._formatElements.length > 0) {
            this._formatElements[0].form(result, number);
        }
        return this.appendRest(result);
    }

    public String form(double number) {
        StringBuffer result = new StringBuffer();
        result.append(this._staticParts.elementAt(0));
        if (this._formatElements.length > 0) {
            this._formatElements[0].form(result, number);
        }
        return this.appendRest(result);
    }

    private String appendRest(StringBuffer buffer) {
        int n = this._staticParts.size();
        for (int i = 1; i < n; ++i) {
            buffer.append(this._staticParts.elementAt(i));
        }
        return new String(buffer);
    }

    public String form(double[] numbers) {
        StringBuffer result = new StringBuffer();
        int n = this._staticParts.size();
        for (int i = 0; i < n; ++i) {
            result.append(this._staticParts.elementAt(i));
            if (i >= this._formatElements.length || i >= numbers.length) continue;
            this._formatElements[i].form(result, numbers[i]);
        }
        return new String(result);
    }
}

