/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import jcckit.Graphics2DPlotCanvas;
import jcckit.GraphicsPlotCanvas;
import jcckit.data.DataCurve;
import jcckit.data.DataElement;
import jcckit.data.DataPlot;
import jcckit.data.DataPoint;
import jcckit.util.ConfigData;
import jcckit.util.ConfigParameters;
import jcckit.util.PropertiesBasedConfigData;

public class Lorenz
extends Applet {
    private double _b = 2.6666666666666665;
    private double _sigma = 10.0;
    private double _r = 28.0;
    private double _dt = 0.015;
    private double[] _x = new double[3];
    private double[] _xDot1 = new double[3];
    private double[] _xDot2 = new double[3];
    private double[][] _walk = new double[50][2];
    private int _walkIndex;
    private DataPlot _dataPlot;
    private Thread _animationThread;

    public void init() {
        GraphicsPlotCanvas plotCanvas = this.createPlotCanvas("true".equals(this.getParameter("graphics2D")));
        this._dataPlot = new DataPlot();
        this._dataPlot.addElement((DataElement)new DataCurve(""));
        this.reset();
        plotCanvas.connect(this._dataPlot);
        this.setLayout(new BorderLayout());
        this.add((Component)plotCanvas.getGraphicsCanvas(), "Center");
        this.add((Component)this.createControlPanel(), "South");
    }

    private GraphicsPlotCanvas createPlotCanvas(boolean graphics2D) {
        Properties props = new Properties();
        ConfigParameters config = new ConfigParameters((ConfigData)new PropertiesBasedConfigData(props));
        ((Hashtable)props).put("foreground", "0xffffff");
        ((Hashtable)props).put("background", "0");
        ((Hashtable)props).put("plot/legendVisible", "false");
        ((Hashtable)props).put("plot/coordinateSystem/xAxis/minimum", "-20");
        ((Hashtable)props).put("plot/coordinateSystem/xAxis/maximum", "20");
        ((Hashtable)props).put("plot/coordinateSystem/xAxis/ticLabelFormat", "%d");
        ((Hashtable)props).put("plot/coordinateSystem/yAxis/axisLabel", "z");
        ((Hashtable)props).put("plot/coordinateSystem/yAxis/minimum", "0");
        ((Hashtable)props).put("plot/coordinateSystem/yAxis/maximum", "50");
        ((Hashtable)props).put("plot/coordinateSystem/yAxis/ticLabelFormat", "%d");
        ((Hashtable)props).put("plot/curveFactory/definitions", "curve");
        ((Hashtable)props).put("plot/curveFactory/curve/initialHintForNextPoint/className", "jcckit.plot.ShapeAttributesHint");
        ((Hashtable)props).put("plot/curveFactory/curve/initialHintForNextPoint/initialAttributes/fillColor", "0x50a");
        ((Hashtable)props).put("plot/curveFactory/curve/initialHintForNextPoint/fillColorHSBIncrement", "0.0 0.0 0.018");
        ((Hashtable)props).put("plot/curveFactory/curve/withLine", "false");
        ((Hashtable)props).put("plot/curveFactory/curve/symbolFactory/className", "jcckit.plot.CircleSymbolFactory");
        ((Hashtable)props).put("plot/curveFactory/curve/symbolFactory/size", "0.015");
        return graphics2D ? new Graphics2DPlotCanvas(config) : new GraphicsPlotCanvas(config);
    }

    private Panel createControlPanel() {
        Panel controlPanel = new Panel();
        Button startButton = new Button("start");
        startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Lorenz.this._animationThread = new Thread(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        while (Lorenz.access$0(1.access$0(this.this$1)) != null) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            Lorenz.access$1(1.access$0(this.this$1));
                        }
                    }
                };
                Lorenz.this._animationThread.start();
            }

            static /* synthetic */ Lorenz access$0(1 var0) {
                return var0.Lorenz.this;
            }
        });
        controlPanel.add(startButton);
        Button stopButton = new Button("stop");
        stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Lorenz.this._animationThread = null;
            }
        });
        controlPanel.add(stopButton);
        Button resetButton = new Button("reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Lorenz.this.reset();
            }
        });
        controlPanel.add(resetButton);
        return controlPanel;
    }

    private void reset() {
        this._x[0] = 10.0 * (Math.random() - 0.5);
        this._x[1] = 10.0 * (Math.random() - 0.5);
        this._x[2] = 10.0;
        int i = 0;
        while (i < this._walk.length) {
            this._walk[i][0] = this._x[0];
            this._walk[i][1] = this._x[2];
            ++i;
        }
        this.updateCurve();
    }

    private void next() {
        this.integrate();
        this._walk[this._walkIndex][0] = this._x[0];
        this._walk[this._walkIndex][1] = this._x[2];
        this._walkIndex = (this._walkIndex + 1) % this._walk.length;
        this.updateCurve();
    }

    private void integrate() {
        this.calculateDerivatives(this._x, this._xDot1);
        int i = 0;
        while (i < this._x.length) {
            int n = i;
            this._x[n] = this._x[n] + this._dt * this._xDot1[i];
            ++i;
        }
        this.calculateDerivatives(this._x, this._xDot2);
        i = 0;
        while (i < this._x.length) {
            int n = i;
            this._x[n] = this._x[n] + 0.5 * this._dt * (this._xDot2[i] - this._xDot1[i]);
            ++i;
        }
    }

    private void calculateDerivatives(double[] x, double[] xDot) {
        xDot[0] = this._sigma * (x[1] - x[0]);
        xDot[1] = this._r * x[0] - x[1] - x[0] * x[2];
        xDot[2] = x[0] * x[1] - this._b * x[2];
    }

    private void updateCurve() {
        DataCurve curve = new DataCurve("trajectory");
        int i = 0;
        while (i < this._walk.length) {
            int index = (this._walkIndex + i) % this._walk.length;
            curve.addElement((DataElement)new DataPoint(this._walk[index][0], this._walk[index][1]));
            ++i;
        }
        this._dataPlot.replaceElementAt(0, (DataElement)curve);
    }

    static /* synthetic */ void access$1(Lorenz lorenz) {
        lorenz.next();
    }
}

