/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import jcckit.util.AppletBasedConfigData;
import jcckit.util.ConfigData;
import jcckit.util.ConfigParameters;

public class BrusselatorApplet
extends Applet {
    private ConfigParameters _config = new ConfigParameters((ConfigData)new AppletBasedConfigData((Applet)this));

    public void init() {
        this.setBackground(this._config.getColor("background", this.getBackground()));
        Brusselator brusselator = this.createBrusselator();
        BrusselatorPlot brusselatorPlot = new BrusselatorPlot(this._config, brusselator);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new TimeView(brusselator));
        this.add((Component)panel, "North");
        this.add((Component)brusselatorPlot.getGraphicsCanvas(), "Center");
        this.add((Component)new BrusselatorController(brusselator).getControlPanel(), "South");
    }

    private Brusselator createBrusselator() {
        double d = this._config.getDouble("dx", 1.0);
        double d2 = this._config.getDouble("dt", 0.05);
        double d3 = this._config.getDouble("L", 100.0);
        Brusselator brusselator = new Brusselator(d, d2, d3);
        brusselator.setNoiseFactor(this._config.getDouble("noiseFactor", 1.0E-4));
        brusselator.setAlpha(this._config.getDouble("alpha", 1.8));
        brusselator.setBeta(this._config.getDouble("beta", 1.0));
        brusselator.setD(this._config.getDouble("d", 9.0));
        brusselator.reset();
        brusselator.addNoise();
        double[] dArray = this._config.getDoubleArray("indices", new double[0]);
        double[] dArray2 = this._config.getDoubleArray("u", new double[0]);
        double[] dArray3 = this._config.getDoubleArray("v", new double[0]);
        int n = Math.min(Math.min(dArray2.length, dArray3.length), dArray.length);
        int n2 = 0;
        while (n2 < n) {
            int n3 = (int)(dArray[n2] + 0.5);
            brusselator.setU(n3, dArray2[n2]);
            brusselator.setV(n3, dArray3[n2]);
            ++n2;
        }
        return brusselator;
    }
}

