/*
 * Decompiled with CFR 0.152.
 */
package jdbm;

import java.io.IOException;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerProvider;

public final class RecordManagerFactory {
    public static RecordManager createRecordManager(String name) throws IOException {
        return RecordManagerFactory.createRecordManager(name, new Properties());
    }

    public static RecordManager createRecordManager(String name, Properties options) throws IOException {
        String provider = options.getProperty("jdbm.provider", "jdbm.recman.Provider");
        ReflectiveOperationException e = null;
        try {
            Class<?> clazz = Class.forName(provider);
            RecordManagerProvider factory = (RecordManagerProvider)clazz.newInstance();
            return factory.createRecordManager(name, options);
        }
        catch (InstantiationException except) {
            e = except;
        }
        catch (IllegalAccessException except) {
            e = except;
        }
        catch (ClassNotFoundException except) {
            e = except;
        }
        throw new IllegalArgumentException("Invalid record manager provider: " + provider, e);
    }
}

