/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdbm.RecordListener;
import jdbm.RecordManager;
import jdbm.helper.JdbmBase;
import jdbm.htree.HTreeMap;
import jdbm.htree.HashDirectory;
import jdbm.htree.HashNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTree<K, V>
implements JdbmBase<K, V> {
    private HashDirectory<K, V> _root;
    protected List<RecordListener<K, V>> recordListeners = new ArrayList<RecordListener<K, V>>();
    transient long hashEqualsIdentityCounter = 0L;

    private HTree(HashDirectory<K, V> root) {
        this._root = root;
    }

    public static <K, V> HTree<K, V> createInstance(RecordManager recman) throws IOException {
        HashDirectory root = new HashDirectory(0);
        long recid = recman.insert(root, HashNode.SERIALIZER);
        root.setPersistenceContext(recman, recid);
        return new HTree(root);
    }

    public static <K, V> HTree<K, V> load(RecordManager recman, long root_recid) throws IOException {
        HashDirectory root = (HashDirectory)recman.fetch(root_recid, HashNode.SERIALIZER);
        root.setPersistenceContext(recman, root_recid);
        HTree<K, V> tree = new HTree<K, V>(root);
        return tree;
    }

    public synchronized void put(K key, V value) throws IOException {
        Object oldVal = null;
        if (!this.recordListeners.isEmpty()) {
            oldVal = this.find(key);
        }
        this._root.put(key, value);
        if (oldVal == null) {
            for (RecordListener<K, V> recordListener : this.recordListeners) {
                recordListener.recordInserted(key, value);
            }
        } else {
            for (RecordListener<K, Object> recordListener : this.recordListeners) {
                recordListener.recordUpdated(key, oldVal, value);
            }
        }
    }

    @Override
    public synchronized V find(K key) throws IOException {
        return this._root.get(key);
    }

    public synchronized void remove(K key) throws IOException {
        Object val = null;
        if (!this.recordListeners.isEmpty()) {
            val = this.find(key);
        }
        this._root.remove(key);
        if (val != null) {
            for (RecordListener<K, Object> recordListener : this.recordListeners) {
                recordListener.recordRemoved(key, val);
            }
        }
    }

    public synchronized Iterator<K> keys() throws IOException {
        return this._root.keys();
    }

    public synchronized Iterator<V> values() throws IOException {
        return this._root.values();
    }

    public long getRecid() {
        return this._root.getRecid();
    }

    public HTreeMap<K, V> asMap() {
        return new HTreeMap(this, false);
    }

    @Override
    public void addRecordListener(RecordListener<K, V> listener) {
        this.recordListeners.add(listener);
    }

    @Override
    public void removeRecordListener(RecordListener<K, V> listener) {
        this.recordListeners.remove(listener);
    }

    @Override
    public RecordManager getRecordManager() {
        return this._root.getRecordManager();
    }
}

