/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import jdbm.SerializerInput;
import jdbm.SerializerOutput;
import jdbm.btree.BPage;
import jdbm.helper.LongPacker;
import jdbm.helper.Serialization;
import jdbm.htree.HTree;
import jdbm.htree.HashNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HashBucket<K, V>
extends HashNode<K, V> {
    static final long serialVersionUID = 1L;
    public static final int OVERFLOW_SIZE = 8;
    private int _depth;
    private ArrayList<K> _keys;
    private ArrayList<V> _values;

    public HashBucket(HTree<K, V> tree) {
        super(tree);
    }

    public HashBucket(HTree<K, V> tree, int level) {
        super(tree);
        if (level > 4) {
            throw new IllegalArgumentException("Cannot create bucket with depth > MAX_DEPTH+1. Depth=" + level);
        }
        this._depth = level;
        this._keys = new ArrayList(8);
        this._values = new ArrayList(8);
    }

    public int getElementCount() {
        return this._keys.size();
    }

    public boolean isLeaf() {
        return this._depth > 3;
    }

    public boolean hasRoom() {
        if (this.isLeaf()) {
            return true;
        }
        return this._keys.size() < 8;
    }

    public V addElement(K key, V value) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            V before = this._values.get(existing);
            this._values.set(existing, value);
            return before;
        }
        this._keys.add(key);
        this._values.add(value);
        return null;
    }

    public V removeElement(K key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            V obj = this._values.get(existing);
            this._keys.remove(existing);
            this._values.remove(existing);
            return obj;
        }
        return null;
    }

    public V getValue(K key) {
        int existing = this._keys.indexOf(key);
        if (existing != -1) {
            return this._values.get(existing);
        }
        return null;
    }

    ArrayList<K> getKeys() {
        return this._keys;
    }

    ArrayList<V> getValues() {
        return this._values;
    }

    public void writeExternal(SerializerOutput out) throws IOException {
        ByteArrayOutputStream baos;
        int i;
        LongPacker.packInt(out, this._depth);
        ArrayList keys = (ArrayList)this._keys.clone();
        if (this.tree.keySerializer != null) {
            for (i = 0; i < this._keys.size(); ++i) {
                if (keys.get(i) == null) continue;
                baos = new ByteArrayOutputStream();
                this.tree.keySerializer.serialize(new SerializerOutput(baos), keys.get(i));
                keys.set(i, baos.toByteArray());
            }
        }
        Serialization.writeObject(out, keys);
        for (i = 0; i < this._keys.size(); ++i) {
            if (this._keys.get(i) == null) continue;
            if (this.tree.valueSerializer == null) {
                Serialization.writeObject(out, this._values.get(i));
                continue;
            }
            baos = new ByteArrayOutputStream();
            this.tree.valueSerializer.serialize(new SerializerOutput(baos), this._values.get(i));
            BPage.writeByteArray(out, baos.toByteArray());
        }
    }

    public void readExternal(SerializerInput in) throws IOException, ClassNotFoundException {
        byte[] serialized;
        int i;
        this._depth = LongPacker.unpackInt(in);
        ArrayList keys = (ArrayList)Serialization.readObject(in);
        if (this.tree.keySerializer != null) {
            for (i = 0; i < keys.size(); ++i) {
                serialized = (byte[])keys.get(i);
                if (serialized == null) continue;
                Object key = this.tree.keySerializer.deserialize(new SerializerInput(new ByteArrayInputStream(serialized)));
                keys.set(i, key);
            }
        }
        this._keys = keys;
        this._values = new ArrayList(this._keys.size());
        for (i = 0; i < this._keys.size(); ++i) {
            if (this._keys.get(i) == null) {
                this._values.add(null);
                continue;
            }
            if (this.tree.valueSerializer == null) {
                this._values.add(Serialization.readObject(in));
                continue;
            }
            serialized = BPage.readByteArray(in);
            Object val = this.tree.valueSerializer.deserialize(new SerializerInput(new ByteArrayInputStream(serialized)));
            this._values.add(val);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("HashBucket {depth=");
        buf.append(this._depth);
        buf.append(", keys=");
        buf.append(this._keys);
        buf.append(", values=");
        buf.append(this._values);
        buf.append("}");
        return buf.toString();
    }
}

