/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import jdbm.Serializer;
import jdbm.SerializerInput;
import jdbm.SerializerOutput;
import jdbm.helper.OpenByteArrayInputStream;
import jdbm.helper.OpenByteArrayOutputStream;
import jdbm.helper.RecordManagerImpl;
import jdbm.recman.BlockIo;
import jdbm.recman.FreeLogicalRowIdPageManager;
import jdbm.recman.FreePhysicalRowIdPageManager;
import jdbm.recman.Location;
import jdbm.recman.LogicalRowIdManager;
import jdbm.recman.PageCursor;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowIdManager;
import jdbm.recman.RecordFile;
import jdbm.recman.TranslationPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseRecordManager
extends RecordManagerImpl {
    private static final String IDR = ".idr";
    private static final String IDF = ".idf";
    private static final String DBR = ".dbr";
    private static final String DBF = ".dbf";
    static final int DATA_BLOCK_SIZE = 8192;
    static final int TRANS_BLOCK_SIZE = 2048;
    static final int FREE_BLOCK_SIZE = 1024;
    static final long STORE_FORMAT_VERSION = 1L;
    private RecordFile _physFile;
    private PageManager _physPageman;
    private PhysicalRowIdManager _physMgr;
    private boolean appendToEnd = false;
    private RecordFile _physFileFree;
    private PageManager _physPagemanFree;
    private RecordFile _logicFile;
    private PageManager _logicPageman;
    private LogicalRowIdManager _logicMgr;
    private RecordFile _logicFileFree;
    private PageManager _logicPagemanFree;
    public static final boolean DEBUG = false;
    private Map<String, Long> _nameDirectory;
    public static final int NAME_DIRECTORY_ROOT = 0;
    public static final int STORE_VERSION_NUMBER_ROOT = 1;
    private boolean compress = false;
    private Deflater deflater;
    private Inflater inflater;
    private static final int BUFFER_SIZE = 8192;
    private final byte[] _insertBuffer = new byte[8192];
    private final OpenByteArrayOutputStream _insertBAO = new OpenByteArrayOutputStream(this._insertBuffer);
    private final SerializerOutput _insertOut = new SerializerOutput(this._insertBAO);
    private final OpenByteArrayInputStream _insertBAI = new OpenByteArrayInputStream(this._insertBuffer);
    private final SerializerInput _insertIn = new SerializerInput(this._insertBAI);
    private volatile boolean bufferInUse = false;
    private final String _filename;

    public boolean isAppendToEnd() {
        return this.appendToEnd;
    }

    public void setAppendToEnd(boolean appendToEnd) {
        this.appendToEnd = appendToEnd;
    }

    public BaseRecordManager(String filename) throws IOException {
        this._filename = filename;
        this.reopen();
    }

    private void reopen() throws IOException {
        this._physFileFree = new RecordFile(this._filename + DBF, 1024);
        this._physPagemanFree = new PageManager(this._physFileFree);
        this._physFile = new RecordFile(this._filename + DBR, 8192);
        this._physPageman = new PageManager(this._physFile);
        this._physMgr = new PhysicalRowIdManager(this._physFile, this._physPageman, new FreePhysicalRowIdPageManager(this._physFileFree, this._physPagemanFree, this.appendToEnd));
        this._logicFileFree = new RecordFile(this._filename + IDF, 1024);
        this._logicPagemanFree = new PageManager(this._logicFileFree);
        this._logicFile = new RecordFile(this._filename + IDR, 2048);
        this._logicPageman = new PageManager(this._logicFile);
        this._logicMgr = new LogicalRowIdManager(this._logicFile, this._logicPageman, new FreeLogicalRowIdPageManager(this._logicFileFree, this._logicPagemanFree));
        long versionNumber = this.getRoot(1);
        if (versionNumber > 1L) {
            throw new IOException("Unsupported version of store. Please update JDBM. Minimal supported ver:1, store ver:" + versionNumber);
        }
        this.setRoot(1, 1L);
    }

    public synchronized void disableTransactions() {
        this.checkIfClosed();
        this._physFile.disableTransactions();
        this._logicFile.disableTransactions();
        this._physFileFree.disableTransactions();
        this._logicFileFree.disableTransactions();
    }

    public synchronized void setCompress(boolean b) {
        this.checkIfClosed();
        this.compress = b;
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this._physPageman.close();
        this._physPageman = null;
        this._physFile.close();
        this._physFile = null;
        this._logicPageman.close();
        this._logicPageman = null;
        this._logicFile.close();
        this._logicFile = null;
        this._physPagemanFree.close();
        this._physPagemanFree = null;
        this._physFileFree.close();
        this._physFileFree = null;
        this._logicPagemanFree.close();
        this._logicPagemanFree = null;
        this._logicFileFree.close();
        this._logicFileFree = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> long insert(A obj, Serializer<A> serializer) throws IOException {
        this.checkIfClosed();
        if (this.bufferInUse) {
            byte[] buffer = new byte[1024];
            OpenByteArrayOutputStream bao = new OpenByteArrayOutputStream(buffer);
            SerializerOutput out = new SerializerOutput(bao);
            return this.insert2(obj, serializer, buffer, bao, out);
        }
        try {
            this.bufferInUse = true;
            this._insertOut.__resetWrittenCounter();
            long l = this.insert2(obj, serializer, this._insertBuffer, this._insertBAO, this._insertOut);
            return l;
        }
        finally {
            this.bufferInUse = false;
        }
    }

    private <A> long insert2(A obj, Serializer<A> serializer, byte[] insertBuffer, OpenByteArrayOutputStream insertBAO, SerializerOutput insertOut) throws IOException {
        insertBAO.reset(insertBuffer);
        serializer.serialize(insertOut, obj);
        if (this.compress) {
            byte[] data = this.compress(insertBAO.getBuf(), insertBAO.size());
            insertBAO.reset(insertBuffer);
            insertBAO.write(data);
        }
        long physRowId = this._physMgr.insert(insertBAO.getBuf(), 0, insertBAO.size());
        long recid = this._logicMgr.insert(physRowId);
        return BaseRecordManager.compressRecid(recid);
    }

    private synchronized byte[] compress(byte[] data, int length) throws IOException {
        if (!this.compress) {
            return data;
        }
        if (this.deflater == null) {
            this.deflater = new Deflater();
        } else {
            this.deflater.reset();
        }
        ByteArrayOutputStream b = new ByteArrayOutputStream(0);
        DeflaterOutputStream d = new DeflaterOutputStream((OutputStream)b, this.deflater);
        ((OutputStream)d).write(data, 0, length);
        ((OutputStream)d).close();
        return b.toByteArray();
    }

    private synchronized SerializerInput decompress(SerializerInput data) throws IOException {
        if (!this.compress) {
            return data;
        }
        if (this.inflater == null) {
            this.inflater = new Inflater();
        } else {
            this.inflater.reset();
        }
        return new SerializerInput(new InflaterInputStream(data, this.inflater));
    }

    @Override
    public synchronized void delete(long logRowId) throws IOException {
        this.checkIfClosed();
        if (logRowId <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + logRowId);
        }
        logRowId = BaseRecordManager.decompressRecid(logRowId);
        long physRowId = this._logicMgr.fetch(logRowId);
        this._physMgr.delete(physRowId);
        this._logicMgr.delete(logRowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> void update(long recid, A obj, Serializer<A> serializer) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        if (this.bufferInUse) {
            byte[] buffer = new byte[1024];
            OpenByteArrayOutputStream bao = new OpenByteArrayOutputStream(buffer);
            SerializerOutput out = new SerializerOutput(bao);
            this.update2(recid, obj, serializer, buffer, bao, out);
            return;
        }
        try {
            this.bufferInUse = true;
            this._insertOut.__resetWrittenCounter();
            this.update2(recid, obj, serializer, this._insertBuffer, this._insertBAO, this._insertOut);
        }
        finally {
            this.bufferInUse = false;
        }
    }

    private <A> void update2(long logRecid, A obj, Serializer<A> serializer, byte[] insertBuffer, OpenByteArrayOutputStream insertBAO, SerializerOutput insertOut) throws IOException {
        long physRecid = this._logicMgr.fetch(logRecid = BaseRecordManager.decompressRecid(logRecid));
        if (physRecid == 0L) {
            throw new IOException("Can not update, recid does not exist: " + logRecid);
        }
        insertBAO.reset(insertBuffer);
        serializer.serialize(insertOut, obj);
        if (this.compress) {
            byte[] data = this.compress(insertBAO.getBuf(), insertBAO.size());
            insertBAO.reset(insertBuffer);
            insertBAO.write(data);
        }
        long newRecid = this._physMgr.update(physRecid, insertBAO.getBuf(), 0, insertBAO.size());
        this._logicMgr.update(logRecid, newRecid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer) throws IOException {
        this.checkIfClosed();
        if (recid <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + recid);
        }
        if (this.bufferInUse) {
            byte[] buffer = new byte[1024];
            OpenByteArrayOutputStream bao = new OpenByteArrayOutputStream(buffer);
            SerializerOutput out = new SerializerOutput(bao);
            OpenByteArrayInputStream bai = new OpenByteArrayInputStream(buffer);
            SerializerInput in = new SerializerInput(bai);
            return this.fetch2(recid, serializer, buffer, bao, out, bai, in);
        }
        try {
            this.bufferInUse = true;
            this._insertOut.__resetWrittenCounter();
            A a = this.fetch2(recid, serializer, this._insertBuffer, this._insertBAO, this._insertOut, this._insertBAI, this._insertIn);
            return a;
        }
        finally {
            this.bufferInUse = false;
        }
    }

    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer, boolean disableCache) throws IOException {
        return this.fetch(recid, serializer);
    }

    private <A> A fetch2(long recid, Serializer<A> serializer, byte[] insertBuffer, OpenByteArrayOutputStream insertBAO, SerializerOutput insertOut, OpenByteArrayInputStream insertBAI, SerializerInput insertIn) throws IOException {
        recid = BaseRecordManager.decompressRecid(recid);
        insertBAO.reset(insertBuffer);
        long physLocation = this._logicMgr.fetch(recid);
        if (physLocation == 0L) {
            return null;
        }
        this._physMgr.fetch(insertBAO, physLocation);
        insertBAI.reset(insertBAO.getBuf(), insertBAO.size());
        try {
            if (this.compress) {
                return serializer.deserialize(this.decompress(insertIn));
            }
            return serializer.deserialize(insertIn);
        }
        catch (ClassNotFoundException e) {
            throw new IOError(e);
        }
    }

    public int getRootCount() {
        return 117;
    }

    public synchronized long getRoot(int id) throws IOException {
        this.checkIfClosed();
        return this._physPageman.getFileHeader().getRoot(id);
    }

    public synchronized void setRoot(int id, long rowid) throws IOException {
        this.checkIfClosed();
        this._physPageman.getFileHeader().setRoot(id, rowid);
    }

    @Override
    public long getNamedObject(String name) throws IOException {
        this.checkIfClosed();
        Map<String, Long> nameDirectory = this.getNameDirectory();
        Long recid = nameDirectory.get(name);
        if (recid == null) {
            return 0L;
        }
        return recid;
    }

    @Override
    public void setNamedObject(String name, long recid) throws IOException {
        this.checkIfClosed();
        Map<String, Long> nameDirectory = this.getNameDirectory();
        if (recid == 0L) {
            nameDirectory.remove(name);
        } else {
            nameDirectory.put(name, new Long(recid));
        }
        this.saveNameDirectory(nameDirectory);
    }

    @Override
    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this._physMgr.commit();
        this._logicMgr.commit();
        this._physPageman.commit();
        this._physPagemanFree.commit();
        this._logicPageman.commit();
        this._logicPagemanFree.commit();
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this._physMgr.commit();
        this._logicMgr.commit();
        this._physPageman.rollback();
        this._physPagemanFree.rollback();
        this._logicPageman.rollback();
        this._logicPagemanFree.rollback();
    }

    private Map<String, Long> getNameDirectory() throws IOException {
        long nameDirectory_recid = this.getRoot(0);
        if (nameDirectory_recid == 0L) {
            this._nameDirectory = new HashMap<String, Long>();
            nameDirectory_recid = this.insert(this._nameDirectory);
            this.setRoot(0, nameDirectory_recid);
        } else {
            this._nameDirectory = (Map)this.fetch(nameDirectory_recid);
        }
        return this._nameDirectory;
    }

    private void saveNameDirectory(Map<String, Long> directory) throws IOException {
        long recid = this.getRoot(0);
        if (recid == 0L) {
            throw new IOException("Name directory must exist");
        }
        this.update(recid, this._nameDirectory);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this._physFile == null) {
            throw new IllegalStateException("RecordManager has been closed");
        }
    }

    @Override
    public synchronized void clearCache() throws IOException {
    }

    @Override
    public synchronized void defrag() throws IOException {
        File f2d;
        File f1d;
        int i;
        File f1t;
        String[] exts;
        this.checkIfClosed();
        this.commit();
        String filename2 = this._filename + "_defrag" + System.currentTimeMillis();
        String filename1 = this._filename;
        BaseRecordManager recman2 = new BaseRecordManager(filename2);
        recman2.disableTransactions();
        PageCursor logicalCur = new PageCursor(this._logicPageman, 2);
        ArrayList<Long> logicalPages = new ArrayList<Long>();
        long last = logicalCur.next();
        while (last != 0L) {
            logicalPages.add(last);
            last = logicalCur.next();
        }
        Iterator i$ = logicalPages.iterator();
        while (i$.hasNext()) {
            long pageid = (Long)i$.next();
            BlockIo io = this._logicFile.get(pageid);
            TranslationPage xlatPage = TranslationPage.getTranslationPageView(io, 2048);
            for (int i2 = 0; i2 < this._logicMgr.ELEMS_PER_PAGE; ++i2) {
                int pos = 18 + i2 * 8;
                if (pos > Short.MAX_VALUE) {
                    throw new Error();
                }
                long logicalRowId = Location.toLong(pageid, (short)pos);
                long physRowId = Location.toLong(xlatPage.getLocationBlock((short)pos), xlatPage.getLocationOffset((short)pos));
                if (physRowId == 0L) continue;
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                this._physMgr.fetch(b, physRowId);
                byte[] bb = b.toByteArray();
                recman2.forceInsert(logicalRowId, bb);
            }
            this._logicFile.release(io);
            recman2.commit();
        }
        recman2.setRoot(0, this.getRoot(0));
        recman2.commit();
        recman2.close();
        this.close();
        ArrayList<File> filesToDelete = new ArrayList<File>();
        for (String ext : exts = new String[]{IDF, IDR, DBF, DBR}) {
            String f1 = filename1 + ext;
            String f2 = filename2 + "_OLD" + ext;
            f1t = new File(f1 + ".t");
            File f2t = new File(f2 + ".t");
            f1t.renameTo(f2t);
            filesToDelete.add(f2t);
            i = 0;
            while ((f1d = new File(f1 + "." + i)).exists()) {
                f2d = new File(f2 + "." + i);
                f1d.renameTo(f2d);
                filesToDelete.add(f2d);
                ++i;
            }
        }
        for (String ext : exts) {
            String f1 = filename2 + ext;
            String f2 = filename1 + ext;
            f1t = new File(f1 + ".t");
            File f2t = new File(f2 + ".t");
            f1t.renameTo(f2t);
            i = 0;
            while ((f1d = new File(f1 + "." + i)).exists()) {
                f2d = new File(f2 + "." + i);
                f1d.renameTo(f2d);
                ++i;
            }
        }
        for (File d : filesToDelete) {
            d.delete();
        }
        this.reopen();
    }

    private void forceInsert(long logicalRowId, byte[] data) throws IOException {
        long physLoc = this._physMgr.insert(data, 0, data.length);
        this._logicMgr.forceInsert(logicalRowId, physLoc);
    }

    static long compressRecid(long recid) {
        long block = Location.getBlock(recid);
        short offset = Location.getOffset(recid);
        if ((offset = (short)(offset - 18)) % 8 != 0) {
            throw new InternalError("not 8");
        }
        long slot = offset / 8;
        if (slot < 0L || slot > 255L) {
            throw new InternalError("too big slot: " + slot);
        }
        return (block << 8) + slot;
    }

    static long decompressRecid(long recid) {
        long block = recid >> 8;
        short offset = (short)((recid & 0xFFL) * 8L + 18L);
        return Location.toLong(block, offset);
    }
}

