/*
 * Decompiled with CFR 0.152.
 */
package info.jdictionary.modules;

import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.JDictionary;
import info.jdictionary.events.PluginScanFinishedEvent;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.events.PluginStructureChangeEvent;
import info.jdictionary.gui.SheetedMutableTreeNode;
import info.jdictionary.listeners.PluginScanFinishedListener;
import info.jdictionary.listeners.PluginSelectionListener;
import info.jdictionary.listeners.PluginStructureChangeListener;
import info.jdictionary.pluginstuff.PluginInfoSheet;
import info.jdictionary.pluginstuff.PluginManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class DefaultTreeView
extends JPanel {
    DefaultFrameAssembler assembler;
    JDictionary jDictionary;
    PluginManager pluginManager;
    DefaultMutableTreeNode rootTreeNode = new DefaultMutableTreeNode(JDictionary.getString("Dictionaries"));
    JTree pluginTree = new JTree(this.rootTreeNode);
    boolean autoSelect = true;

    public DefaultTreeView(DefaultFrameAssembler assembler) {
        this.assembler = assembler;
        this.jDictionary = assembler.getJDictionary();
        this.pluginManager = this.jDictionary.getPluginManager();
        this.pluginTree.expandPath(new TreePath(((DefaultMutableTreeNode)((DefaultTreeModel)this.pluginTree.getModel()).getRoot()).getPath()));
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pluginTree, "West");
        this.pluginTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultTreeView.this.pluginTree_valueChanged(e);
            }
        });
        assembler.getJDictionary().getPluginManager().addPluginStructureChangeListener(new PluginStructureChangeListener(){

            public void pluginAdded(PluginStructureChangeEvent e) {
                DefaultTreeView.this.pluginManager_pluginAdded(e);
            }

            public void pluginRemoved(PluginStructureChangeEvent e) {
                DefaultTreeView.this.pluginManager_pluginRemoved(e);
            }
        });
        assembler.getJDictionary().getPluginManager().addPluginSelectionListener(new PluginSelectionListener(){

            public void pluginSelected(PluginSelectionEvent e) {
                DefaultTreeView.this.pluginManager_pluginSelected(e);
            }
        });
        assembler.getJDictionary().getPluginManager().addPluginScanFinishedListener(new PluginScanFinishedListener(){

            public void pluginScanFinished(PluginScanFinishedEvent e) {
                DefaultTreeView.this.pluginManager_pluginScanFinished(e);
            }
        });
    }

    void pluginManager_pluginAdded(final PluginStructureChangeEvent e) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    SheetedMutableTreeNode node = new SheetedMutableTreeNode(e.getPluginInfoSheet());
                    ((DefaultTreeModel)DefaultTreeView.this.pluginTree.getModel()).insertNodeInto(node, DefaultTreeView.this.rootTreeNode, 0);
                    ArrayList plugin = DefaultTreeView.this.assembler.getJDictionary().getPluginManager().getPlugin(e.getPluginInfoSheet());
                    Iterator pluginIterator = ((AbstractList)plugin).iterator();
                    while (pluginIterator.hasNext()) {
                        DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(pluginIterator.next());
                        ((DefaultTreeModel)DefaultTreeView.this.pluginTree.getModel()).insertNodeInto(leaf, node, 0);
                    }
                    DefaultTreeView.this.checkExpand(node);
                    DefaultTreeView.this.pluginTree.validate();
                    DefaultTreeView.this.pluginTree.repaint();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void pluginManager_pluginRemoved(final PluginStructureChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SheetedMutableTreeNode tempNode = null;
                for (int n = 0; n < DefaultTreeView.this.rootTreeNode.getChildCount(); ++n) {
                    tempNode = (SheetedMutableTreeNode)DefaultTreeView.this.rootTreeNode.getChildAt(n);
                    if (!tempNode.getInfoSheet().equals(e.getPluginInfoSheet())) continue;
                    ((DefaultTreeModel)DefaultTreeView.this.pluginTree.getModel()).removeNodeFromParent(tempNode);
                    DefaultTreeView.this.pluginTree.validate();
                    DefaultTreeView.this.pluginTree.repaint();
                }
            }
        });
    }

    void pluginManager_pluginScanFinished(PluginScanFinishedEvent e) {
        this.autoSelect = false;
    }

    void pluginManager_pluginSelected(PluginSelectionEvent e) {
        if (e.getSelectedPlugin() == null) {
            if (this.pluginTree.getLastSelectedPathComponent() != null && !((DefaultMutableTreeNode)this.pluginTree.getLastSelectedPathComponent()).isRoot()) {
                this.pluginTree.setSelectionPath(null);
            }
            return;
        }
        for (int i = 0; i < this.rootTreeNode.getChildCount(); ++i) {
            SheetedMutableTreeNode node = (SheetedMutableTreeNode)this.rootTreeNode.getChildAt(i);
            if (e.getSelectedPlugin() != node.getInfoSheet()) continue;
            for (int j = 0; j < node.getChildCount(); ++j) {
                if (e.getSelectedSubPlugin() != node.getChildAt(j).toString()) continue;
                TreePath path = new TreePath(((DefaultMutableTreeNode)node.getChildAt(j)).getPath());
                this.pluginTree.setSelectionPath(path);
                return;
            }
        }
    }

    void pluginTree_valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode selectedNode;
        if (this.pluginTree.getSelectionCount() == 0) {
            return;
        }
        DefaultMutableTreeNode node = selectedNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        PluginInfoSheet sheet = null;
        if (selectedNode.isRoot()) {
            this.assembler.getOutput().showDefault();
            return;
        }
        while (node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (node instanceof SheetedMutableTreeNode) {
            sheet = ((SheetedMutableTreeNode)node).getInfoSheet();
        }
        if (selectedNode.isLeaf()) {
            this.jDictionary.getPluginManager().selectPlugin(sheet, selectedNode.toString());
        } else {
            this.jDictionary.getPluginManager().selectPlugin(sheet);
        }
    }

    void checkExpand(SheetedMutableTreeNode node) {
        this.pluginTree.expandPath(new TreePath(this.rootTreeNode.getPath()));
        if (!this.autoSelect) {
            return;
        }
        if (this.jDictionary.getPrefs().lastSelectedPlugin == null) {
            this.assembler.getOutput().showDefault();
            this.autoSelect = false;
            return;
        }
        if (node.getInfoSheet().getFileName().equals(this.jDictionary.getPrefs().lastSelectedPlugin.getFileName())) {
            TreePath path = new TreePath(node.getPath());
            this.pluginTree.expandPath(path);
            for (int n = 0; n < node.getChildCount(); ++n) {
                if (this.jDictionary.getPrefs().lastSelectedSubPluginName == null || !node.getChildAt(n).toString().equals(this.jDictionary.getPrefs().lastSelectedSubPluginName)) continue;
                this.pluginTree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)node.getChildAt(n)).getPath()));
                this.autoSelect = false;
                return;
            }
            this.pluginTree.setSelectionPath(path);
            this.autoSelect = false;
            return;
        }
    }
}

