/*
 * 01/09/2002 - 20:43:57
 *
 * NetworkErrorCenteredPanel.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.gui;

import info.jdictionary.JDictionary;
import info.jdictionary.gui.NetworkErrorPanel;
import javax.swing.JPanel;
import javax.swing.JComponent;
import javax.swing.BoxLayout;
import java.awt.Color;


public class NetworkErrorCenteredPanel extends JPanel {

    private JDictionary jDictionary;
    private NetworkErrorPanel networkErrorPanel;

    public NetworkErrorCenteredPanel(JDictionary jDictionary) {
        super();
        this.jDictionary = jDictionary;

        setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        setBackground(Color.white);

        JPanel spacer1 = new JPanel();
        spacer1.setBackground(Color.white);
        JPanel spacer2 = new JPanel();
        spacer2.setBackground(Color.white);
        JPanel spacer3 = new JPanel();
        spacer3.setBackground(Color.white);
        JPanel spacer4 = new JPanel();
        spacer4.setBackground(Color.white);

        networkErrorPanel = new NetworkErrorPanel(jDictionary);

        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, BoxLayout.Y_AXIS));
        panel.setBackground(Color.white);
        panel.add(spacer1);
        panel.add(networkErrorPanel);
        panel.add(spacer2);

        add(spacer3);
        add(panel);
        add(spacer4);
    }


    public NetworkErrorPanel getNetworkErrorPanel() {
        return networkErrorPanel;
    }
}