/*
 * 01/09/2002 - 20:43:57
 *
 * DefaultToolBar.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary.modules;

import info.jdictionary.JDictionary;
import info.jdictionary.pluginstuff.PluginManager;
import info.jdictionary.DefaultFrameAssembler;
import info.jdictionary.events.NewsEvent;
import info.jdictionary.events.NewJDictionaryVersionEvent;
import info.jdictionary.events.PluginScanFinishedEvent;
import info.jdictionary.events.PluginSelectionEvent;
import info.jdictionary.listeners.NewsListener;
import info.jdictionary.listeners.NewJDictionaryVersionListener;
import info.jdictionary.listeners.PluginScanFinishedListener;
import info.jdictionary.listeners.PluginSelectionListener;
import info.jdictionary.IconBank;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.Component;
import java.awt.Insets;

public class DefaultToolBar extends JToolBar {

    DefaultFrameAssembler assembler;
    PluginManager pluginManager;
    JButton downloadButton = new JButton();
    JButton activateButton = new JButton();
    JButton rescanButton = new JButton();
    JButton preferencesButton = new JButton();
    JButton newsButton = new JButton();
    JButton upgradeButton;
    ButtonFlasher downloadButtonFlasher;
    ButtonFlasher activateButtonFlasher;
    ButtonFlasher upgradeButtonFlasher;
    ButtonFlasher newsButtonFlasher;


    public DefaultToolBar(DefaultFrameAssembler assembler) {
        super();
        this.assembler = assembler;
        this.pluginManager = assembler.getJDictionary().getPluginManager();
        setFloatable(false);
        putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        add(rescanButton);
        add(activateButton);
        add(downloadButton);
        add(preferencesButton);
        add(newsButton);

        pluginManager.addPluginScanFinishedListener(new PluginScanFinishedListener() {
            public void pluginScanFinished(PluginScanFinishedEvent e) {
                pluginManager_PluginScanFinished(e);
            }

        });

        downloadButton.setIcon(IconBank.FolderIn);
        downloadButton.setMargin(new Insets(2,2,2,2));
        downloadButton.setToolTipText(JDictionary.getString("Download&Install"));
        downloadButton.addActionListener(new java.awt.event.ActionListener() {
                                                  public void actionPerformed(ActionEvent e) {
                                                      downloadButton_actionPerformed(e);
                                                  }
                                              }
                                             );

        activateButton.setIcon(IconBank.plug);
        activateButton.setMargin(new Insets(2,2,2,2));
        activateButton.setToolTipText(JDictionary.getString("ActivateDeactivate"));
        activateButton.addActionListener(new java.awt.event.ActionListener() {
                                                public void actionPerformed(ActionEvent e) {
                                                    activateButton_actionPerformed(e);
                                                }
                                            }
                                           );

        rescanButton.setIcon(IconBank.rescan);
        rescanButton.setMargin(new Insets(2,2,2,2));
        rescanButton.setToolTipText(JDictionary.getString("Rescan"));
        rescanButton.addActionListener(new java.awt.event.ActionListener() {
                                                public void actionPerformed(ActionEvent e) {
                                                    rescanButton_actionPerformed(e);
                                                }
                                            }
                                           );

        preferencesButton.setIcon(IconBank.hammer);
        preferencesButton.setMargin(new Insets(2,2,2,2));
        preferencesButton.setToolTipText(JDictionary.getString("Preferences"));
        preferencesButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                preferencesButton_actionPerformed(e);
            }
        });

        newsButton.setIcon(IconBank.envelope);
        newsButton.setMargin(new Insets(2,2,2,2));
        newsButton.setToolTipText(JDictionary.getString("News"));
        newsButton.addActionListener(new java.awt.event.ActionListener() {
                                                public void actionPerformed(ActionEvent e) {
                                                    newsButton_actionPerformed(e);
                                                }
                                            }
                                           );

        assembler.getJDictionary().getNewsChecker().addNewsListener(new NewsListener() {
                                                public void newsUpdated(NewsEvent e) {
                                                    newsChecker_newsUpdated(e);
                                                }
                                              }
                                            );

        assembler.getJDictionary().getNewJDictionaryVersionChecker().addNewJDictionaryVersionListener(new NewJDictionaryVersionListener() {
            public void newJDictionaryVersionAvailable(NewJDictionaryVersionEvent e) {
                newJDictionaryVersionChecker_newJDictionaryVersionAvailable(e);
            }
        });
    }


    void downloadButton_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPluginDownloader());
    }


    void activateButton_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPluginStatusChanger());
    }


    void rescanButton_actionPerformed(ActionEvent e) {
        assembler.getJDictionary().getPluginManager().scanPlugins();
    }


    void preferencesButton_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getPreferencesScreen());
    }


    void newsButton_actionPerformed(ActionEvent e) {
        assembler.getOutput().show(assembler.getJDictionary().getNewsAgent());
    }


    void upgradeButton_actionPerformed(ActionEvent e){
        assembler.getOutput().show(assembler.getJDictionary().getUpgradeAgent());
    }


    void pluginManager_PluginScanFinished(PluginScanFinishedEvent e) {
        if(pluginManager.getNumberOfPluginFiles() == 0) {
            if(downloadButtonFlasher == null) {
                pluginManager.addPluginSelectionListener(new PluginSelectionListener () {
                    public void pluginSelected(PluginSelectionEvent e) {
                        if(assembler.getOutput().getOutputComponent() != null && assembler.getOutput().getOutputComponent() instanceof info.jdictionary.pluginstuff.PluginDownloader) {
                            downloadButtonFlasher.terminate();
                            downloadButton.setIcon(IconBank.FolderIn);
                            downloadButton.setBackground(downloadButton.getParent().getBackground());
                        }
                    }
                });
            }
            else
                downloadButtonFlasher.terminate();
          downloadButtonFlasher = new ButtonFlasher(downloadButton, IconBank.FolderIn, IconBank.Folder, 4);
          downloadButtonFlasher.start();
        }
        else
            if(downloadButtonFlasher != null) {
                downloadButtonFlasher.terminate();
                downloadButton.setBackground(downloadButton.getParent().getBackground());
        }

        if(pluginManager.getNumberOfPluginFiles() > 0 && pluginManager.getNumberOfLoadedPlugins() == 0) {
            if(activateButtonFlasher == null) {
                pluginManager.addPluginSelectionListener(new PluginSelectionListener () {
                    public void pluginSelected(PluginSelectionEvent e) {
                        if(assembler.getOutput().getOutputComponent() != null && assembler.getOutput().getOutputComponent() instanceof info.jdictionary.pluginstuff.PluginStatusChanger) {
                            activateButtonFlasher.terminate();
                            activateButton.setIcon(IconBank.plug);
                            activateButton.setBackground(activateButton.getParent().getBackground());
                        }
                    }
                });
            }
            else
                activateButtonFlasher.terminate();
          activateButtonFlasher = new ButtonFlasher(activateButton, IconBank.unPlug, IconBank.plug, 4);
          activateButtonFlasher.start();
        }
        else
            if(activateButtonFlasher != null) {
                activateButtonFlasher.terminate();
                activateButton.setIcon(IconBank.plug);
                activateButton.setBackground(activateButton.getParent().getBackground());
            }
    }


    void newsChecker_newsUpdated(NewsEvent e) {
        if(assembler.getOutput().getOutputComponent() != null && assembler.getOutput().getOutputComponent() instanceof info.jdictionary.NewsAgent)
            return;
        if(newsButtonFlasher == null) {
            pluginManager.addPluginSelectionListener(new PluginSelectionListener () {
                public void pluginSelected(PluginSelectionEvent e) {
                    if(assembler.getOutput().getOutputComponent() != null && assembler.getOutput().getOutputComponent() instanceof info.jdictionary.NewsAgent) {
                            newsButtonFlasher.terminate();
                            newsButton.setIcon(IconBank.envelope);
                            newsButton.setBackground(newsButton.getParent().getBackground());
                        }
                    }
                });
        }
        else
            newsButtonFlasher.terminate();
        newsButtonFlasher = new ButtonFlasher(newsButton, IconBank.envelopeOpen, IconBank.envelope, 4);
        newsButtonFlasher.start();
    }


    void newJDictionaryVersionChecker_newJDictionaryVersionAvailable(NewJDictionaryVersionEvent e) {
        upgradeButton = new JButton(IconBank.laptopIn);
        upgradeButton.setToolTipText(JDictionary.getString("NewJDictionaryAvailableToolTip"));
        upgradeButton.setMargin(new Insets(2,2,2,2));
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                add(upgradeButton);
                validate();
                repaint();
            }
        });
        upgradeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                upgradeButton_actionPerformed(e);
            }
        });
        if(upgradeButtonFlasher == null) {
            pluginManager.addPluginSelectionListener(new PluginSelectionListener () {
                public void pluginSelected(PluginSelectionEvent e) {
                    if(assembler.getOutput().getOutputComponent() != null && assembler.getOutput().getOutputComponent() instanceof info.jdictionary.gui.UpgradeAgent) {
                        upgradeButtonFlasher.terminate();
                        upgradeButton.setIcon(IconBank.laptopIn);
                        upgradeButton.setBackground(upgradeButton.getParent().getBackground());
                    }
                }
            });
        }
        else
            upgradeButtonFlasher.terminate();
        upgradeButtonFlasher = new ButtonFlasher(upgradeButton, IconBank.laptop, IconBank.laptopIn, 4);
        upgradeButtonFlasher.start();
    }


    class ButtonFlasher extends Thread {
        private JButton button;
        private ImageIcon icon1;
        private ImageIcon icon2;
        private int count;
        private boolean stop = false;


        public ButtonFlasher(JButton button, ImageIcon icon1, ImageIcon icon2, int count) {
            this.icon1 = icon1;
            this.icon2 = icon2;
            this.button = button;
            this.count = count;
        }


        public void terminate() {
            stop = true;
        }


        public void run() {
            for(int i = 0; i < count; i++) {
                try {
                    sleep(500);
                    if(!stop)
                        button.setIcon(icon2);
                    else
                        return;
                    sleep(500);
                    if(!stop)
                        button.setIcon(icon1);
                    else
                        return;
                }
            catch(java.lang.InterruptedException e) {}
            }
            if(!stop)
                button.setBackground(Color.orange);
        }
    }
}
